/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.row;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.schema.BinaryTupleComparator;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchemaTypes;
import org.apache.ignite.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite.internal.type.NativeType;

public class ProjectAwareBinaryTupleComparator
extends BinaryTupleComparator {
    private final IntList columnMapping;

    public static Comparator<ByteBuffer> createsBinaryTupleComparator(RowSchema rowSchema, RelCollation collation) {
        ArrayList<NativeType> columnTypes = new ArrayList<NativeType>(collation.getFieldCollations().size());
        ArrayList<CatalogColumnCollation> columnCollations = new ArrayList<CatalogColumnCollation>(collation.getFieldCollations().size());
        IntArrayList columnMapping = new IntArrayList(collation.getFieldCollations().size());
        for (RelFieldCollation col : collation.getFieldCollations()) {
            boolean asc = !col.getDirection().isDescending();
            boolean nullsFirst = col.nullDirection == RelFieldCollation.NullDirection.FIRST;
            columnCollations.add(CatalogColumnCollation.get((boolean)asc, (boolean)nullsFirst));
            int fieldIndex = col.getFieldIndex();
            columnMapping.add(fieldIndex);
            TypeSpec typeSpec = rowSchema.fields().get(fieldIndex);
            columnTypes.add(typeSpec == RowSchemaTypes.NULL ? null : RowSchemaTypes.toNativeType(typeSpec));
        }
        return new ProjectAwareBinaryTupleComparator(columnCollations, columnTypes, (IntList)columnMapping, rowSchema.fields().size());
    }

    private ProjectAwareBinaryTupleComparator(List<CatalogColumnCollation> columnCollations, List<NativeType> columnTypes, IntList columnMapping, int numElements) {
        super(columnCollations, columnTypes, numElements);
        assert (columnMapping.size() == columnCollations.size());
        this.columnMapping = columnMapping;
    }

    protected int compareField(int colIdx, BinaryTupleReader tuple1, BinaryTupleReader tuple2) {
        assert (!(tuple1 instanceof BinaryTuplePrefix));
        assert (!(tuple2 instanceof BinaryTuplePrefix));
        int mappedIdx = this.columnMapping.getInt(colIdx);
        return this.compareField(colIdx, tuple1, tuple2, mappedIdx);
    }
}

