/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.offload;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.NoOpMemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.offload.OffloadAwareCollection;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;

@NotThreadSafe
class OffloadAwareSetAdapter<RowT, E>
implements RowSet<E>,
OffloadAwareCollection {
    private final Supplier<RowSet<E>> fileCollectionSupplier;
    private MemoryContext<RowT> memoryContext;
    private RowSet<E> delegate;
    private final Runnable offloadingTrigger;
    private boolean wasSpilled;
    private boolean wasClosed;

    OffloadAwareSetAdapter(MemoryContext<RowT> memoryContext, RowSet<E> delegate, Supplier<RowSet<E>> fileCollectionSupplier, Runnable offloadingTrigger) {
        this.memoryContext = memoryContext;
        this.delegate = delegate;
        this.fileCollectionSupplier = fileCollectionSupplier;
        this.offloadingTrigger = offloadingTrigger;
    }

    @Override
    public boolean add(E element) {
        Objects.requireNonNull(element, "element");
        this.acquire(element);
        boolean added = this.delegate.add(element);
        if (!added) {
            this.memoryContext.releaseObject(element);
        }
        return added;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.release((E)this.delegate);
        this.delegate.clear();
    }

    @Override
    public void close() {
        if (this.wasClosed) {
            return;
        }
        this.wasClosed = true;
        this.release((E)this.delegate);
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSpillToDisk() {
        if (this.wasSpilled || this.wasClosed) {
            return;
        }
        this.wasSpilled = true;
        RowSet<E> inMemoryCollection = this.delegate;
        RowSet fileCollection = this.fileCollectionSupplier.get();
        this.delegate = fileCollection;
        try {
            for (Object row : inMemoryCollection) {
                fileCollection.add(row);
                this.release(row);
            }
        }
        finally {
            this.memoryContext = NoOpMemoryContext.instance();
            IgniteUtils.closeQuiet(inMemoryCollection::close);
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.checkClosed();
        return this.delegate.iterator();
    }

    private void checkClosed() {
        if (this.wasClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
        }
    }

    private void acquire(E element) {
        if (this.offloadingTrigger == null) {
            this.memoryContext.acquireObject(element);
            return;
        }
        if (!this.memoryContext.tryAcquireObject(element)) {
            this.offloadingTrigger.run();
        }
    }

    private void release(Iterable<E> rows) {
        if (this.wasSpilled) {
            return;
        }
        rows.forEach(this::release);
    }

    private void release(E row) {
        this.memoryContext.releaseObject(row);
    }
}

