/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalFileStore;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.TransformingIterator;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

class ExternalFileQueue
implements RowQueue<BinaryTuple>,
AutoCloseable {
    private final Deque<ExternalFileStore> rowStores = new LinkedList<ExternalFileStore>();
    private final DataDirectory workDir;
    private final FileIoFactory fileIoFactory;
    private final int columnsCount;
    private final int maxRowsPerFile;
    private boolean closed;

    ExternalFileQueue(FileIoFactory fileIoFactory, DataDirectory workDir, int columnsCount, int maxRowsPerFile) {
        Objects.requireNonNull(workDir, "workDir");
        Objects.requireNonNull(fileIoFactory, "fileIoFactory");
        if (columnsCount <= 0) {
            throw new IllegalArgumentException("columnsCount must be positive: " + columnsCount);
        }
        if (maxRowsPerFile <= 0) {
            throw new IllegalArgumentException("maxRowsPerFile must be positive: " + maxRowsPerFile);
        }
        this.workDir = workDir;
        this.fileIoFactory = fileIoFactory;
        this.columnsCount = columnsCount;
        this.maxRowsPerFile = maxRowsPerFile;
        this.createNextFile();
    }

    @Override
    public synchronized void add(BinaryTuple element) {
        Objects.requireNonNull(element, "element");
        this.checkClosed();
        this.rolloverIfNeeded();
        this.lastStore().write(element);
    }

    @Override
    public synchronized int size() {
        this.checkClosed();
        return this.rowStores.stream().mapToInt(ExternalFileStore::size).sum();
    }

    @Override
    public synchronized boolean isEmpty() {
        this.checkClosed();
        return this.rowStores.getFirst().size() == 0;
    }

    @Override
    public synchronized void clear() {
        this.checkClosed();
        Iterator<ExternalFileStore> itr = this.rowStores.iterator();
        while (itr.hasNext()) {
            ExternalFileStore store = itr.next();
            if (!itr.hasNext()) {
                store.reset();
                continue;
            }
            store.close();
            itr.remove();
        }
    }

    @Override
    public synchronized Iterator<BinaryTuple> iterator() {
        this.checkClosed();
        TransformingIterator iterator = new TransformingIterator(this.rowStores.iterator(), ExternalFileStore::iterator);
        return CollectionUtils.concat((Iterator)iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ExternalFileQueue externalFileQueue = this;
        synchronized (externalFileQueue) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        for (ExternalFileStore rowStore : this.rowStores) {
            rowStore.close();
        }
    }

    @Override
    @Nullable
    public synchronized BinaryTuple peek() {
        this.checkClosed();
        return this.rowStores.getFirst().readFirst();
    }

    @Override
    @Nullable
    public synchronized BinaryTuple poll() {
        this.checkClosed();
        ExternalFileStore rowStore = this.rowStores.getFirst();
        BinaryTuple tuple = rowStore.removeFirst();
        if (tuple != null && rowStore.size() == 0) {
            if (this.rowStores.size() == 1) {
                rowStore.reset();
            } else {
                rowStore.close();
                this.rowStores.removeFirst();
            }
        }
        return tuple;
    }

    @Override
    public BinaryTuple remove() {
        BinaryTuple tuple = this.poll();
        if (tuple == null) {
            throw new NoSuchElementException();
        }
        return tuple;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Queue row store is closed.");
        }
    }

    private ExternalFileStore lastStore() {
        return this.rowStores.getLast();
    }

    private void rolloverIfNeeded() {
        if (this.lastStore().size() == this.maxRowsPerFile) {
            this.createNextFile();
        }
    }

    private void createNextFile() {
        this.rowStores.addLast(new ExternalFileStore(this.fileIoFactory, this.workDir, this.columnsCount));
    }
}

