/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.sql.ColumnType;

public class SingleNativeTypeValueCodec<E>
implements KeyValueCodec<E, Void> {
    private final NativeType keyType;

    public SingleNativeTypeValueCodec(Class<E> clazz, NativeType keyType) {
        this.keyType = keyType;
    }

    @Override
    public BinaryTuple encodeKey(E key) {
        return this.toBinaryTuple(key);
    }

    @Override
    public E decodeKey(BinaryTuple key) {
        return this.fromBinaryTuple(key);
    }

    @Override
    public ByteBuffer encodeValue(Void val, ByteBuffer buf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Void decodeValue(ByteBuffer buf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int initialValueSizeInBytes() {
        return 0;
    }

    private BinaryTuple toBinaryTuple(E value) {
        boolean exactEstimate;
        int size;
        if (this.keyType.fixedLength()) {
            size = this.keyType.sizeInBytes();
            exactEstimate = true;
        } else if (this.keyType.spec() == ColumnType.STRING) {
            String str = (String)value;
            size = str.length();
            exactEstimate = false;
        } else if (this.keyType.spec() == ColumnType.BYTE_ARRAY) {
            ByteString byteString = (ByteString)value;
            size = byteString.length();
            exactEstimate = true;
        } else if (this.keyType.spec() == ColumnType.DECIMAL) {
            size = 26;
            exactEstimate = false;
        } else {
            throw new InvalidTypeException("Unsupported variable-length type: " + this.keyType);
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(1, size, exactEstimate);
        this.appendValue(builder, value);
        return new BinaryTuple(1, builder.build());
    }

    private E fromBinaryTuple(BinaryTuple tuple) {
        return (E)this.fromBinaryTupleElement(tuple);
    }

    private Object fromBinaryTupleElement(BinaryTuple value) {
        Object result = Commons.readValue((InternalTuple)value, this.keyType, 0);
        assert (result != null);
        if (this.keyType.spec() == ColumnType.BYTE_ARRAY) {
            return new ByteString((byte[])result);
        }
        return result;
    }

    private void appendValue(BinaryTupleBuilder builder, Object value) {
        switch (this.keyType.spec()) {
            case BOOLEAN: {
                builder.appendBoolean(((Boolean)value).booleanValue());
                break;
            }
            case INT8: {
                builder.appendByte(((Byte)value).byteValue());
                break;
            }
            case INT16: {
                builder.appendShort(((Short)value).shortValue());
                break;
            }
            case INT32: {
                builder.appendInt(((Integer)value).intValue());
                break;
            }
            case INT64: {
                builder.appendLong(((Long)value).longValue());
                break;
            }
            case FLOAT: {
                builder.appendFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                builder.appendDouble(((Double)value).doubleValue());
                break;
            }
            case DECIMAL: {
                builder.appendDecimalNotNull((BigDecimal)value, ((DecimalNativeType)this.keyType).scale());
                break;
            }
            case UUID: {
                builder.appendUuidNotNull((UUID)value);
                break;
            }
            case BYTE_ARRAY: {
                ByteString byteString = (ByteString)value;
                builder.appendBytesNotNull(byteString.getBytes());
                break;
            }
            case STRING: {
                builder.appendStringNotNull((String)value);
                break;
            }
            case DATE: {
                builder.appendDateNotNull((LocalDate)value);
                break;
            }
            case TIME: {
                builder.appendTimeNotNull((LocalTime)value);
                break;
            }
            case DATETIME: {
                builder.appendDateTimeNotNull((LocalDateTime)value);
                break;
            }
            case TIMESTAMP: {
                builder.appendTimestampNotNull((Instant)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + this.keyType);
            }
        }
    }
}

