/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping.largecluster;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTargetFactory;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.AbstractTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.AllOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.OneOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.PartitionedTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.SomeOfTarget;

public class LargeClusterFactory
implements ExecutionTargetFactory {
    private final List<String> nodes;
    private final Object2IntMap<String> nodeNameToId;

    public LargeClusterFactory(List<String> nodes) {
        this.nodes = nodes;
        this.nodeNameToId = new Object2IntOpenHashMap(nodes.size());
        this.nodeNameToId.defaultReturnValue(-1);
        int idx = 0;
        for (String name : nodes) {
            int ret = this.nodeNameToId.putIfAbsent((Object)name, idx++);
            assert (ret == -1) : "invalid node";
        }
    }

    @Override
    public ExecutionTarget allOf(List<String> nodes) {
        LargeClusterFactory.ensureNonEmptyTarget(nodes);
        BitSet nodesSet = new BitSet(this.nodeNameToId.size());
        for (String name : nodes) {
            int id = this.nodeNameToId.getOrDefault((Object)name, -1);
            if (id == -1) {
                throw new MappingException("Mandatory node was excluded from mapping: " + name);
            }
            nodesSet.set(id);
        }
        return new AllOfTarget(nodesSet);
    }

    @Override
    public ExecutionTarget oneOf(List<String> nodes) {
        LargeClusterFactory.ensureNonEmptyTarget(nodes);
        return new OneOfTarget(this.nodeListToMap(nodes));
    }

    @Override
    public ExecutionTarget someOf(List<String> nodes) {
        LargeClusterFactory.ensureNonEmptyTarget(nodes);
        return new SomeOfTarget(this.nodeListToMap(nodes));
    }

    @Override
    public ExecutionTarget partitioned(List<TokenizedAssignments> assignments) {
        LargeClusterFactory.ensureNonEmptyTarget(assignments);
        BitSet[] partitionNodes = new BitSet[assignments.size()];
        long[] enlistmentConsistencyTokens = new long[assignments.size()];
        int idx = 0;
        boolean finalised = true;
        for (TokenizedAssignments assignment : assignments) {
            BitSet nodes = new BitSet(this.nodeNameToId.size());
            for (Assignment a : assignment.nodes()) {
                int node = this.nodeNameToId.getOrDefault((Object)a.consistentId(), -1);
                if (node == -1) continue;
                nodes.set(node);
            }
            if (nodes.isEmpty()) {
                List nodes0 = assignment.nodes().stream().map(Assignment::consistentId).collect(Collectors.toList());
                throw new MappingException("Mandatory nodes were excluded from mapping: " + nodes0);
            }
            finalised = finalised && nodes.cardinality() < 2;
            partitionNodes[idx] = nodes;
            enlistmentConsistencyTokens[idx] = assignment.token();
            ++idx;
        }
        return new PartitionedTarget(finalised, partitionNodes, enlistmentConsistencyTokens);
    }

    @Override
    public List<String> resolveNodes(ExecutionTarget target) {
        assert (target instanceof AbstractTarget) : target == null ? "<null>" : target.getClass().getCanonicalName();
        target = ((AbstractTarget)target).finalise();
        return ((AbstractTarget)target).nodes(this.nodes);
    }

    @Override
    public Int2ObjectMap<NodeWithConsistencyToken> resolveAssignments(ExecutionTarget target) {
        assert (target instanceof AbstractTarget) : target == null ? "<null>" : target.getClass().getCanonicalName();
        target = ((AbstractTarget)target).finalise();
        return ((AbstractTarget)target).assignments(this.nodes);
    }

    private BitSet nodeListToMap(List<String> nodes) {
        BitSet nodesSet = new BitSet(this.nodeNameToId.size());
        for (String name : nodes) {
            int id = this.nodeNameToId.getOrDefault((Object)name, -1);
            if (id < 0) continue;
            nodesSet.set(id);
        }
        if (nodesSet.isEmpty()) {
            throw new MappingException("Mandatory nodes were excluded from mapping: " + nodes);
        }
        return nodesSet;
    }

    public static void ensureNonEmptyTarget(List<?> nodes) {
        if (nodes.isEmpty()) {
            throw new MappingException("Empty target is not allowed");
        }
    }
}

