/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.ProgramExecutionHandle;
import org.apache.ignite.internal.sql.engine.exec.fsm.ProgramExecutionState;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite.internal.sql.engine.exec.fsm.Transition;
import org.apache.ignite.internal.util.ExceptionUtils;

class Program<ResultT> {
    private static final IgniteLogger LOG = Loggers.forClass(Program.class);
    private final String name;
    private final Map<ExecutionPhase, Transition> transitions;
    private final Predicate<ExecutionPhase> terminalPhase;
    private final Function<Query, ResultT> result;
    private final BiPredicate<Query, Throwable> errorHandler;

    Program(String name, List<Transition> transitions, Predicate<ExecutionPhase> terminalPhase, Function<Query, ResultT> result, BiPredicate<Query, Throwable> errorHandler) {
        this.name = name;
        this.transitions = new EnumMap(transitions.stream().collect(Collectors.toMap(Transition::from, Function.identity())));
        this.terminalPhase = terminalPhase;
        this.result = result;
        this.errorHandler = errorHandler;
    }

    ProgramExecutionState<ResultT> createState() {
        return new ProgramExecutionState(this.name);
    }

    void run(Query query, ProgramExecutionState<ResultT> state) {
        do {
            Result result;
            ExecutionPhase phase = query.currentPhase();
            try {
                result = phase.evaluate(query);
            }
            catch (Throwable th) {
                if (this.shouldRetry(query, th)) continue;
                query.setError(th);
                Program.finalizeActiveProgram(query, state);
                return;
            }
            if (result.status() != Result.Status.WAITING_FOR_COMPLETION) continue;
            CompletableFuture<Void> awaitFuture = result.await();
            assert (awaitFuture != null);
            if (awaitFuture.isDone() && !awaitFuture.isCompletedExceptionally()) continue;
            awaitFuture.whenComplete((ignored, ex) -> {
                if (ex != null) {
                    if (this.shouldRetry(query, ex = ExceptionUtils.unwrapCause((Throwable)ex))) {
                        query.executor.execute(() -> this.run(query, state));
                    } else {
                        query.setError((Throwable)ex);
                        Program.finalizeActiveProgram(query, state);
                    }
                    return;
                }
                query.executor.execute(() -> {
                    if (this.advanceQuery(query, state)) {
                        this.run(query, state);
                    }
                });
            });
            break;
        } while (this.advanceQuery(query, state));
    }

    private boolean shouldRetry(Query query, Throwable th) {
        try {
            if (this.errorHandler.test(query, th)) {
                return true;
            }
        }
        catch (Throwable throwableFromErrorHandler) {
            LOG.warn("Exception in error handler [queryId={}]", throwableFromErrorHandler, new Object[]{query.id});
            query.terminateExceptionally(th);
        }
        return false;
    }

    private static void finalizeActiveProgram(Query query, ProgramExecutionState<?> executionState) {
        ProgramExecutionHandle activeHandle = query.activeProgram.getAndSet(null);
        Throwable throwable = query.error.get();
        if (throwable != null) {
            executionState.notifyError(throwable);
            query.terminate();
        }
        executionState.programFinished.complete(null);
        assert (activeHandle == executionState);
    }

    private boolean advanceQuery(Query query, ProgramExecutionState<ResultT> state) {
        ExecutionPhase phase = query.currentPhase();
        Transition transition = this.transitions.get((Object)phase);
        assert (transition != null) : "Transition not found in program \"" + this.name + "\" for phase " + phase;
        transition.move(query);
        if (this.terminalPhase.test(query.currentPhase())) {
            ResultT result = this.result.apply(query);
            Program.finalizeActiveProgram(query, state);
            if (!state.resultHolder.complete(result)) {
                assert (state.resultHolder.isCompletedExceptionally());
                query.moveTo(ExecutionPhase.TERMINATED);
            }
            return false;
        }
        return true;
    }
}

