/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import org.apache.calcite.sql.SqlNode;
import org.apache.ignite.internal.sql.engine.exec.fsm.DdlBatchAware;
import org.apache.ignite.internal.sql.engine.exec.fsm.DdlBatchGroup;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.jetbrains.annotations.Nullable;

public class DdlBatchingHelper {
    static boolean isCompatible(ParsedResult thisStatement, ParsedResult thatStatement) {
        @Nullable DdlBatchGroup batchGroup = thisStatement.ddlBatchGroup();
        @Nullable DdlBatchGroup statementGroup = thatStatement.ddlBatchGroup();
        if (batchGroup == null || statementGroup == null) {
            assert (false) : "DDL statement should be batch aware.";
            return false;
        }
        return DdlBatchingHelper.isCompatible(batchGroup, statementGroup);
    }

    static boolean isCompatible(DdlBatchGroup thisGroup, DdlBatchGroup thatGroup) {
        return thisGroup != DdlBatchGroup.OTHER && thisGroup == thatGroup || thisGroup == DdlBatchGroup.DROP;
    }

    @Nullable
    public static DdlBatchGroup extractDdlBatchGroup(SqlNode node) {
        DdlBatchAware batchAwareAnnotation = node.getClass().getDeclaredAnnotation(DdlBatchAware.class);
        return batchAwareAnnotation == null ? null : batchAwareAnnotation.group();
    }

    private DdlBatchingHelper() {
    }
}

