/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.util.CompletableFutures;

class CursorInitializationPhaseHandler
implements ExecutionPhaseHandler {
    static final ExecutionPhaseHandler INSTANCE = new CursorInitializationPhaseHandler();

    private CursorInitializationPhaseHandler() {
    }

    @Override
    public Result handle(Query query) {
        QueryPlan plan = query.plan;
        SqlOperationContext context = query.operationContext;
        assert (plan != null);
        assert (context != null);
        SqlQueryType queryType = plan.type();
        query.cancel.throwIfCancelled();
        CompletionStage awaitFuture = query.executor.executePlan(context, plan).thenCompose(dataCursor -> {
            AsyncSqlCursor<InternalSqlRow> cursor;
            try {
                cursor = query.executor.createAndSaveSqlCursor(query, (AsyncDataCursor<InternalSqlRow>)dataCursor);
            }
            catch (QueryCancelledException ignored) {
                return dataCursor.onClose();
            }
            if (queryType == SqlQueryType.QUERY) {
                return CompletableFutures.nullCompletedFuture();
            }
            return cursor.onFirstPageReady();
        });
        return Result.proceedAfter((CompletableFuture<Void>)awaitFuture);
    }
}

