/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql.sequence;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.exec.fsm.DdlBatchAware;
import org.apache.ignite.internal.sql.engine.exec.fsm.DdlBatchGroup;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

@DdlBatchAware(group=DdlBatchGroup.CREATE)
public class SqlCreateSequence
extends SqlCreate {
    private final SqlIdentifier name;
    private final long increment;
    private final long minvalue;
    private final long maxvalue;
    private final long start;
    private final long cache;

    public SqlCreateSequence(SqlParserPos pos, boolean existFlag, SqlIdentifier name, @Nullable Long increment, @Nullable Long minvalue, @Nullable Long maxvalue, @Nullable Long start, @Nullable Long cache) {
        super((SqlOperator)SqlCreateSequence.operatorWithDefaults(existFlag, increment, minvalue, maxvalue, start, cache), pos, false, existFlag);
        this.name = Objects.requireNonNull(name, "name");
        Operator op = (Operator)super.getOperator();
        this.increment = op.increment;
        this.minvalue = op.minvalue;
        this.maxvalue = op.maxvalue;
        this.start = op.start;
        this.cache = op.cache;
    }

    private static Operator operatorWithDefaults(boolean existFlag, @Nullable Long increment, @Nullable Long minvalue, @Nullable Long maxvalue, @Nullable Long start, @Nullable Long cache) {
        long inc = Objects.requireNonNullElse(increment, 1L);
        long min = Objects.requireNonNullElse(minvalue, inc > 0L ? 1L : Long.MIN_VALUE);
        long max = Objects.requireNonNullElse(maxvalue, inc > 0L ? Long.MAX_VALUE : -1L);
        long st = Objects.requireNonNullElse(start, inc > 0L ? min : max);
        long c = Objects.requireNonNullElse(cache, 1000L);
        return new Operator(existFlag, inc, min, max, st, c);
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE SEQUENCE");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.keyword("INCREMENT BY");
        writer.literal(String.valueOf(this.increment));
        writer.keyword("MINVALUE");
        writer.literal(String.valueOf(this.minvalue));
        writer.keyword("MAXVALUE");
        writer.literal(String.valueOf(this.maxvalue));
        writer.keyword("START");
        writer.literal(String.valueOf(this.start));
        writer.keyword("CACHE");
        writer.literal(String.valueOf(this.cache));
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public long increment() {
        return this.increment;
    }

    public long minvalue() {
        return this.minvalue;
    }

    public long maxvalue() {
        return this.maxvalue;
    }

    public long start() {
        return this.start;
    }

    public long cache() {
        return this.cache;
    }

    public boolean ifNotExists() {
        return this.getOperator().existFlag();
    }

    protected static class Operator
    extends IgniteDdlOperator {
        private final long increment;
        private final long minvalue;
        private final long maxvalue;
        private final long start;
        private final long cache;

        public Operator(boolean existFlag, long increment, long minvalue, long maxvalue, long start, Long cache) {
            super("CREATE SEQUENCE", SqlKind.CREATE_SEQUENCE, existFlag);
            this.increment = increment;
            this.minvalue = minvalue;
            this.maxvalue = maxvalue;
            this.start = start;
            this.cache = cache;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlCreateSequence(pos, this.existFlag(), (SqlIdentifier)operands[0], this.increment, this.minvalue, this.maxvalue, this.start, this.cache);
        }
    }
}

