/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Litmus;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlTablePropertyKey;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlTableProperty
extends SqlCall {
    private static final SqlOperator OPERATOR = new Operator();
    private final SqlLiteral key;
    private final SqlNode value;

    public IgniteSqlTableProperty(SqlLiteral key, SqlNode value, SqlParserPos pos) {
        super(pos);
        this.key = key;
        this.value = value;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return List.of(this.key, this.value);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new IgniteSqlTableProperty(this.key, this.value, pos);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.key().sqlName);
        this.value.unparse(writer, leftPrec, rightPrec);
    }

    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof IgniteSqlTableProperty)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        IgniteSqlTableProperty that = (IgniteSqlTableProperty)node;
        if (this.key != that.key) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        return this.value.equalsDeep(that.value, litmus);
    }

    public IgniteSqlTablePropertyKey key() {
        return (IgniteSqlTablePropertyKey)((Object)this.key.getValueAs(IgniteSqlTablePropertyKey.class));
    }

    public SqlNode value() {
        return this.value;
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        protected Operator() {
            super("TableProperty", SqlKind.OTHER);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlTableProperty((SqlLiteral)operands[0], operands[1], pos);
        }
    }
}

