/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.exec.fsm.DdlBatchAware;
import org.apache.ignite.internal.sql.engine.sql.IgniteAbstractSqlAlterTable;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

@DdlBatchAware
public class IgniteSqlAlterColumn
extends IgniteAbstractSqlAlterTable {
    private final SqlIdentifier columnName;
    private final SqlDataTypeSpec type;
    private final boolean dropDefault;
    private final SqlNode dflt;
    private final Boolean notNull;

    public IgniteSqlAlterColumn(SqlParserPos pos, boolean ifExists, SqlIdentifier tblName, SqlIdentifier columnName, @Nullable SqlDataTypeSpec type, boolean dropDefault, @Nullable SqlNode dflt, @Nullable Boolean notNull) {
        super(new Operator(ifExists, dropDefault, notNull), pos, tblName);
        this.columnName = columnName;
        this.type = type;
        this.dropDefault = dropDefault;
        this.dflt = dflt;
        this.notNull = notNull;
    }

    public SqlIdentifier columnName() {
        return this.columnName;
    }

    @Nullable
    public SqlDataTypeSpec dataType() {
        return this.type;
    }

    @Nullable
    public SqlNode expression() {
        return this.dflt;
    }

    @Nullable
    public Boolean notNull() {
        return this.notNull;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnName, (Object)this.type, (Object)this.dflt);
    }

    @Override
    protected void unparseAlterTableOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER");
        writer.keyword("COLUMN");
        this.columnName().unparse(writer, leftPrec, rightPrec);
        if (this.type != null) {
            writer.keyword("SET DATA TYPE");
            this.type.unparse(writer, 0, 0);
            if (this.notNull != null) {
                if (this.notNull.booleanValue()) {
                    writer.keyword("NOT");
                }
                writer.keyword("NULL");
            }
            if (this.dflt != null) {
                writer.keyword("DEFAULT");
                this.dflt.unparse(writer, leftPrec, rightPrec);
            }
            return;
        }
        if (this.notNull != null) {
            writer.keyword(this.notNull != false ? "SET" : "DROP");
            writer.keyword("NOT NULL");
        }
        if (this.dropDefault) {
            writer.keyword("DROP DEFAULT");
        } else if (this.dflt != null) {
            writer.keyword("SET DEFAULT");
            this.dflt.unparse(writer, leftPrec, rightPrec);
        }
    }

    protected static class Operator
    extends IgniteDdlOperator {
        private final boolean dropDefault;
        private final Boolean notNull;

        protected Operator(boolean ifExists, boolean dropDefault, Boolean notNull) {
            super("ALTER TABLE", SqlKind.ALTER_TABLE, ifExists);
            this.dropDefault = dropDefault;
            this.notNull = notNull;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlAlterColumn(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlIdentifier)operands[1], (SqlDataTypeSpec)operands[2], this.dropDefault, operands[3], this.notNull);
        }
    }
}

