/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.show;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.ignite.internal.sql.ColumnMetadataImpl;
import org.apache.ignite.internal.sql.ResultSetMetadataImpl;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowGrantsCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowPrivilegesGrantsCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowRoleCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowRolesCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowUserCommand;
import org.apache.ignite.internal.sql.engine.prepare.show.ShowUsersCommand;
import org.apache.ignite.internal.sql.engine.sql.SqlShow;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlShowGrants;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlShowPrivilegesGrants;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlShowRole;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlShowRoles;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlShowUser;
import org.apache.ignite.internal.sql.engine.sql.rbac.GridgainSqlShowUsers;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlException;

public class QuerySqlToShowCommandConverter {
    public ShowCommand convert(SqlShow showNode, PlanningContext ctx) {
        if (showNode instanceof GridgainSqlShowUser) {
            return QuerySqlToShowCommandConverter.convertShowUser((GridgainSqlShowUser)showNode);
        }
        if (showNode instanceof GridgainSqlShowUsers) {
            return new ShowUsersCommand();
        }
        if (showNode instanceof GridgainSqlShowRole) {
            return QuerySqlToShowCommandConverter.convertShowRole((GridgainSqlShowRole)showNode);
        }
        if (showNode instanceof GridgainSqlShowRoles) {
            return new ShowRolesCommand();
        }
        if (showNode instanceof GridgainSqlShowGrants) {
            return QuerySqlToShowCommandConverter.convertShowGrants((GridgainSqlShowGrants)showNode);
        }
        if (showNode instanceof GridgainSqlShowPrivilegesGrants) {
            return QuerySqlToShowCommandConverter.convertShowPrivilegeGrants((GridgainSqlShowPrivilegesGrants)showNode);
        }
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported operation [sqlNodeKind=" + showNode.getKind() + "; querySql=\"" + ctx.query() + "\"]");
    }

    private static ShowUserCommand convertShowUser(GridgainSqlShowUser sqlCmd) {
        ShowUserCommand showUserCommand = new ShowUserCommand();
        showUserCommand.username(sqlCmd.username().getSimple());
        return showUserCommand;
    }

    private static ShowRoleCommand convertShowRole(GridgainSqlShowRole sqlCmd) {
        ShowRoleCommand showRoleCommand = new ShowRoleCommand();
        showRoleCommand.name(sqlCmd.name().getSimple());
        return showRoleCommand;
    }

    private static ShowGrantsCommand convertShowGrants(GridgainSqlShowGrants sqlCmd) {
        ShowGrantsCommand showGrantsCommand = new ShowGrantsCommand();
        SqlIdentifier name = sqlCmd.name();
        showGrantsCommand.name(name != null ? name.getSimple() : null);
        return showGrantsCommand;
    }

    private static ShowPrivilegesGrantsCommand convertShowPrivilegeGrants(GridgainSqlShowPrivilegesGrants sqlCmd) {
        SqlIdentifier name = sqlCmd.roleName();
        SqlIdentifier selector = sqlCmd.selector();
        return new ShowPrivilegesGrantsCommand(name.getSimple(), selector != null ? selector.getSimple() : null);
    }

    public ResultSetMetadata convertMetadata(SqlShow showNode, PlanningContext planningContext) {
        if (showNode instanceof GridgainSqlShowUser || showNode instanceof GridgainSqlShowUsers) {
            return QuerySqlToShowCommandConverter.showUserMetadata();
        }
        if (showNode instanceof GridgainSqlShowRole || showNode instanceof GridgainSqlShowRoles) {
            return QuerySqlToShowCommandConverter.showRoleMetadata();
        }
        if (showNode instanceof GridgainSqlShowGrants) {
            return QuerySqlToShowCommandConverter.showGrantsMetadata();
        }
        if (showNode instanceof GridgainSqlShowPrivilegesGrants) {
            return QuerySqlToShowCommandConverter.showPrivilegeGrantsMetadata();
        }
        return new ResultSetMetadataImpl(List.of());
    }

    private static ResultSetMetadataImpl showUserMetadata() {
        return new ResultSetMetadataImpl(List.of(QuerySqlToShowCommandConverter.stringColumn("USERNAME"), QuerySqlToShowCommandConverter.stringColumn("ROLES")));
    }

    private static ResultSetMetadataImpl showRoleMetadata() {
        return new ResultSetMetadataImpl(List.of(QuerySqlToShowCommandConverter.stringColumn("ROLE"), QuerySqlToShowCommandConverter.stringColumnNullable("ACTION"), QuerySqlToShowCommandConverter.stringColumnNullable("OBJECT")));
    }

    private static ResultSetMetadataImpl showGrantsMetadata() {
        return new ResultSetMetadataImpl(List.of(QuerySqlToShowCommandConverter.stringColumn("USER"), QuerySqlToShowCommandConverter.stringColumn("ROLE")));
    }

    private static ResultSetMetadataImpl showPrivilegeGrantsMetadata() {
        return new ResultSetMetadataImpl(List.of(QuerySqlToShowCommandConverter.stringColumn("ROLE"), QuerySqlToShowCommandConverter.stringColumnNullable("ACTION"), QuerySqlToShowCommandConverter.stringColumnNullable("OBJECT")));
    }

    private static ColumnMetadataImpl stringColumn(String name) {
        return new ColumnMetadataImpl(name, ColumnType.STRING, -1, Integer.MIN_VALUE, false, null);
    }

    private static ColumnMetadataImpl stringColumnNullable(String name) {
        return new ColumnMetadataImpl(name, ColumnType.STRING, -1, Integer.MIN_VALUE, true, null);
    }
}

