/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.pruning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteMergeJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScanWithAggregate;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteUnionAll;
import org.apache.ignite.internal.sql.engine.rel.IgniteValues;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

class ModifyNodeVisitor
implements IgniteRelVisitor<List<List<RexNode>>> {
    private static final IgniteLogger LOG = Loggers.forClass(ModifyNodeVisitor.class);

    private ModifyNodeVisitor() {
    }

    @Nullable
    static List<List<RexNode>> go(IgniteTableModify tableModify) {
        ModifyNodeVisitor modifyNodeShuttle = new ModifyNodeVisitor();
        return modifyNodeShuttle.visit((IgniteRel)tableModify.getInput());
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteValues rel) {
        return Commons.cast(rel.tuples);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteProject rel) {
        List<List<RexNode>> result = this.processSingleInputRel(rel);
        if (CollectionUtils.nullOrEmpty(result)) {
            return result;
        }
        ArrayList<List<RexNode>> projectedResult = new ArrayList<List<RexNode>>(result.size());
        for (final List<RexNode> inputExpressions : result) {
            RexShuttle inputInliner = new RexShuttle(){

                public RexNode visitInputRef(RexInputRef inputRef) {
                    return (RexNode)inputExpressions.get(inputRef.getIndex());
                }
            };
            projectedResult.add(inputInliner.visitList((Iterable)rel.getProjects()));
        }
        return projectedResult;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteUnionAll rel) {
        List<IgniteRel> inputs = Commons.cast(rel.getInputs());
        ArrayList<List<RexNode>> results = new ArrayList<List<RexNode>>();
        for (IgniteRel input : inputs) {
            Object inputResult = this.visit(input);
            if (inputResult == null) {
                return null;
            }
            results.addAll((Collection<List<RexNode>>)inputResult);
        }
        return results;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteSort rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteTableSpool rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteSortedIndexSpool rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteLimit rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteHashIndexSpool rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteSender rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteFilter rel) {
        if (rel.getCondition().isAlwaysFalse()) {
            return List.of();
        }
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteTrimExchange rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteExchange rel) {
        return this.processSingleInputRel(rel);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteNestedLoopJoin rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteHashJoin rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteCorrelatedNestedLoopJoin rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteMergeJoin rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteIndexScan rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteTableScan rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteSystemViewScan rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteReceiver rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteColocatedHashAggregate rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteMapHashAggregate rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteReduceHashAggregate rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteColocatedSortAggregate rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteMapSortAggregate rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteReduceSortAggregate rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteSetOp rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteTableFunctionScan rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteTableModify rel) {
        return ModifyNodeVisitor.processUnexpected("Plan can contains only one ModifyNode.", new Object[0]);
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteKeyValueGet rel) {
        return ModifyNodeVisitor.processUnexpected("KV plans are not supposed to be part of distributed plans [node={}].", rel.getClass().getName());
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteKeyValueModify rel) {
        return ModifyNodeVisitor.processUnexpected("KV plans are not supposed to be part of distributed plans [node={}].", rel.getClass().getName());
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteSelectCount rel) {
        return ModifyNodeVisitor.processUnexpected("SelectCountPlan is not supposed to be part of distributed plans [node={}].", rel.getClass().getName());
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteTableScanWithAggregate rel) {
        return null;
    }

    @Override
    @Nullable
    public List<List<RexNode>> visit(IgniteRel rel) {
        return rel.accept(this);
    }

    @Nullable
    private List<List<RexNode>> processSingleInputRel(IgniteRel rel) {
        List inputs = Commons.cast(rel.getInputs());
        assert (inputs.size() == 1) : "Relation with multiple inputs must be processed explicitly";
        if (inputs.size() != 1) {
            return null;
        }
        return this.visit((IgniteRel)inputs.get(0));
    }

    @Nullable
    private static List<List<RexNode>> processUnexpected(String messageTemplate, Object ... args) {
        if (IgniteUtils.assertionsEnabled()) {
            String message = IgniteStringFormatter.format((String)messageTemplate, (Object[])args);
            assert (false) : message;
        }
        LOG.warn(messageTemplate, args);
        return null;
    }
}

