/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMetadata;
import org.apache.ignite.internal.sql.engine.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.sql.engine.prepare.IgniteSqlToRelConvertor;
import org.apache.ignite.internal.sql.engine.prepare.IgniteSqlValidator;
import org.apache.ignite.internal.sql.engine.prepare.PlannerPhase;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.ValidationResult;
import org.apache.ignite.internal.sql.engine.rex.IgniteRexBuilder;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlParser;
import org.apache.ignite.internal.sql.engine.sql.StatementParseResult;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class IgnitePlanner
implements Planner,
RelOptTable.ViewExpander {
    private final SqlOperatorTable operatorTbl;
    private final List<Program> programs;
    private final FrameworkConfig frameworkCfg;
    private final PlanningContext ctx;
    private final List<RelTraitDef> traitDefs;
    private final SqlParser.Config parserCfg;
    private final SqlToRelConverter.Config sqlToRelConverterCfg;
    private final SqlValidator.Config validatorCfg;
    private final SqlRexConvertletTable convertletTbl;
    private final RexBuilder rexBuilder;
    private final RexExecutor rexExecutor;
    private final IgniteTypeFactory typeFactory;
    private final CalciteCatalogReader catalogReader;
    @Nullable
    private SqlNode validatedSqlNode;
    private RelOptPlanner planner;
    private SqlValidator validator;
    private RelOptCluster cluster;
    private final long startTs;

    IgnitePlanner(PlanningContext ctx) {
        this.ctx = ctx;
        this.typeFactory = ctx.typeFactory();
        this.catalogReader = ctx.catalogReader();
        this.operatorTbl = ctx.opTable();
        this.frameworkCfg = ctx.config();
        this.programs = this.frameworkCfg.getPrograms();
        this.parserCfg = this.frameworkCfg.getParserConfig();
        this.sqlToRelConverterCfg = this.frameworkCfg.getSqlToRelConverterConfig();
        this.validatorCfg = this.frameworkCfg.getSqlValidatorConfig();
        this.convertletTbl = this.frameworkCfg.getConvertletTable();
        this.rexExecutor = this.frameworkCfg.getExecutor();
        this.traitDefs = this.frameworkCfg.getTraitDefs();
        this.rexBuilder = IgniteRexBuilder.INSTANCE;
        this.startTs = FastTimestamps.coarseCurrentTimeMillis();
    }

    public RelTraitSet getEmptyTraitSet() {
        return this.planner().emptyTraitSet();
    }

    public void close() {
        this.reset();
    }

    public void reset() {
        this.planner = null;
        this.validator = null;
        this.cluster = null;
    }

    public SqlNode parse(Reader reader) throws SqlParseException {
        StatementParseResult parseResult = IgniteSqlParser.parse(reader, StatementParseResult.MODE);
        return parseResult.statement();
    }

    public SqlNode validate(SqlNode sqlNode) {
        this.validatedSqlNode = this.validator().validate(sqlNode);
        return this.validatedSqlNode;
    }

    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) {
        SqlNode validatedNode = this.validator().validate(sqlNode);
        RelDataType type = this.validator().getValidatedNodeType(validatedNode);
        this.validatedSqlNode = validatedNode;
        return Pair.of((Object)validatedNode, (Object)type);
    }

    public RelDataType getParameterRowType() {
        return Objects.requireNonNull(this.validator, "validator").getParameterRowType(Objects.requireNonNull(this.validatedSqlNode, "validatedSqlNode"));
    }

    public RelDataType convert(SqlDataTypeSpec typeSpec, boolean nullable) {
        this.validator().validateDataType(typeSpec);
        return typeSpec.deriveType(this.validator(), nullable);
    }

    public RelNode convert(SqlNode sql) {
        throw new UnsupportedOperationException();
    }

    List<RelHint> deriveHints(SqlNode node) {
        SqlSelect select = null;
        if (node instanceof SqlSelect) {
            select = (SqlSelect)node;
        } else if (node instanceof SqlWith && ((SqlWith)node).body instanceof SqlSelect) {
            select = (SqlSelect)((SqlWith)node).body;
        }
        if (select != null && select.hasHints()) {
            return SqlUtil.getRelHint((HintStrategyTable)this.cluster().getHintStrategies(), (SqlNodeList)select.getHints());
        }
        return List.of();
    }

    static void warmup() {
        PlannerPhase.values();
    }

    ValidationResult validateAndGetTypeMetadata(SqlNode sqlNode) {
        SqlNodeList selectItems = null;
        ArrayList<SqlNode> selectItemsNoStar = null;
        SqlNode sqlNode0 = sqlNode instanceof SqlOrderBy ? ((SqlOrderBy)sqlNode).query : sqlNode;
        boolean starFound = false;
        if (sqlNode0 instanceof SqlSelect) {
            selectItems = SqlNonNullableAccessors.getSelectList((SqlSelect)((SqlSelect)sqlNode0));
            selectItemsNoStar = new ArrayList<SqlNode>(selectItems.size());
            for (SqlNode node : selectItems) {
                if (node instanceof SqlIdentifier) {
                    SqlIdentifier id = (SqlIdentifier)node;
                    if (!id.isStar()) continue;
                    starFound = true;
                    continue;
                }
                if (node instanceof SqlBasicCall) {
                    SqlBasicCall node0 = (SqlBasicCall)node;
                    if (this.identAsIdent(node0)) continue;
                    selectItemsNoStar.add(node);
                    continue;
                }
                selectItemsNoStar.add(node);
            }
        }
        SqlNode validatedNode = this.validator().validate(sqlNode);
        RelDataType type = this.validator().getValidatedNodeType(validatedNode);
        List origins = this.validator().getFieldOrigins(validatedNode);
        ArrayList<String> derived = null;
        if (validatedNode instanceof SqlSelect && selectItems != null && !selectItemsNoStar.isEmpty()) {
            derived = new ArrayList<String>(selectItems.size());
            if (starFound) {
                SqlNodeList expandedItems = ((SqlSelect)validatedNode).getSelectList();
                int resolved = 0;
                for (SqlNode node : expandedItems) {
                    SqlBasicCall node0;
                    if (node instanceof SqlIdentifier) {
                        derived.add(null);
                        continue;
                    }
                    if (node instanceof SqlBasicCall && this.identAsIdent(node0 = (SqlBasicCall)node)) {
                        derived.add(null);
                        continue;
                    }
                    Objects.checkIndex(resolved, selectItemsNoStar.size());
                    derived.add(this.validator().deriveAlias((SqlNode)selectItemsNoStar.get(resolved), resolved));
                    ++resolved;
                }
            } else {
                int cnt = 0;
                for (SqlNode node : selectItems) {
                    derived.add(this.validator().deriveAlias(node, cnt++));
                }
            }
        }
        this.validatedSqlNode = validatedNode;
        return new ValidationResult(validatedNode, type, origins, derived == null ? List.of() : derived);
    }

    private boolean identAsIdent(SqlBasicCall node) {
        return node.operandCount() == 2 && node.getKind() == SqlKind.AS && node.operand(0) instanceof SqlIdentifier && node.operand(1) instanceof SqlIdentifier;
    }

    public RelRoot rel(SqlNode sql) {
        IgniteSqlToRelConvertor sqlToRelConverter = this.sqlToRelConverter();
        return sqlToRelConverter.convertQuery(sql, false, true);
    }

    public RelRoot expandView(RelDataType rowType, String qryStr, List<String> schemaPath, List<String> viewPath) {
        SqlNode sqlNode;
        SqlParser parser = SqlParser.create((String)qryStr, (SqlParser.Config)this.parserCfg);
        try {
            sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new SqlException(ErrorGroups.Sql.STMT_PARSE_ERR, "parse failed", (Throwable)e);
        }
        CalciteCatalogReader catalogReader = this.catalogReader.withSchemaPath(schemaPath);
        IgniteSqlValidator validator = new IgniteSqlValidator(this.operatorTbl, catalogReader, this.typeFactory, this.validatorCfg, this.ctx.parameters());
        IgniteSqlToRelConvertor sqlToRelConverter = this.sqlToRelConverter((SqlValidator)validator, catalogReader, this.sqlToRelConverterCfg);
        RelRoot root = sqlToRelConverter.convertQuery(sqlNode, true, false);
        root = root.withRel(sqlToRelConverter.decorrelate(sqlNode, root.rel));
        return this.trimUnusedFields(root);
    }

    public RelNode transform(int programIdx, RelTraitSet targetTraits, RelNode rel) {
        return this.programs.get(programIdx).run(this.planner(), rel, targetTraits.simplify(), this.materializations(), this.latices());
    }

    public <T extends RelNode> T transform(PlannerPhase phase, RelTraitSet targetTraits, RelNode rel) {
        return (T)phase.getProgram(this.ctx).run(this.planner(), rel, targetTraits.simplify(), this.materializations(), this.latices());
    }

    public IgniteTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    private RelOptPlanner planner() {
        if (this.planner == null) {
            VolcanoPlannerExt planner = new VolcanoPlannerExt(this.frameworkCfg.getCostFactory(), this.ctx, this.startTs);
            planner.setExecutor(this.rexExecutor);
            this.planner = planner;
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
        return this.planner;
    }

    public void addListener(RelOptListener newListener) {
        this.planner().addListener(newListener);
    }

    public String dump() {
        StringWriter w = new StringWriter();
        ((VolcanoPlanner)this.planner).dump(new PrintWriter(w));
        return w.toString();
    }

    public SqlValidator validator() {
        if (this.validator == null) {
            this.validator = new IgniteSqlValidator(this.operatorTbl, this.catalogReader, this.typeFactory, this.validatorCfg, this.ctx.parameters());
        }
        return this.validator;
    }

    RelOptCluster cluster() {
        if (this.cluster == null) {
            this.cluster = RelOptCluster.create((RelOptPlanner)this.planner(), (RexBuilder)this.rexBuilder);
            this.cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(IgniteMetadata.METADATA_PROVIDER, this.planner()));
            this.cluster.setMetadataQuerySupplier(RelMetadataQueryEx::create);
            this.cluster.setHintStrategies(this.frameworkCfg.getSqlToRelConverterConfig().getHintStrategyTable());
        }
        return this.cluster;
    }

    private List<RelOptLattice> latices() {
        return List.of();
    }

    private List<RelOptMaterialization> materializations() {
        return List.of();
    }

    protected RelRoot trimUnusedFields(RelRoot root) {
        SqlToRelConverter.Config config = this.sqlToRelConverterCfg.withExpand(false).withTrimUnusedFields(true);
        IgniteSqlToRelConvertor converter = this.sqlToRelConverter(this.validator(), this.catalogReader, config);
        boolean ordered = !root.collation.getFieldCollations().isEmpty();
        boolean dml = SqlKind.DML.contains(root.kind);
        return root.withRel(converter.trimUnusedFields(dml || ordered, root.rel));
    }

    public RelNode replaceCorrelatesCollisions(RelNode rel) {
        RelHomogeneousShuttle relShuttle = new RelHomogeneousShuttle(){
            private final Set<CorrelationId> usedSet = new HashSet<CorrelationId>();
            private final Map<CorrelationId, CorrelationId> replaceMap = new HashMap<CorrelationId, CorrelationId>();
            private final Map<CorrelationId, Integer> removeMap = new HashMap<CorrelationId, Integer>();
            private final RexShuttle rexShuttle = new RexShuttle(){

                public RexNode visitCorrelVariable(RexCorrelVariable variable) {
                    CorrelationId newCorId = replaceMap.get(variable.id);
                    if (newCorId != null) {
                        return IgnitePlanner.this.cluster().getRexBuilder().makeCorrel(variable.getType(), newCorId);
                    }
                    return variable;
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RelNode visit(LogicalCorrelate correlate) {
                CorrelationId corId = correlate.getCorrelationId();
                if (this.usedSet.contains(corId)) {
                    if (this.removeMap.containsKey(corId)) {
                        LogicalJoin join = LogicalJoin.create((RelNode)correlate.getLeft(), (RelNode)correlate.getRight(), List.of(), (RexNode)IgnitePlanner.this.cluster().getRexBuilder().makeLiteral(true), Set.of(), (JoinRelType)correlate.getJoinType());
                        return super.visit((RelNode)join);
                    }
                    CorrelationId newCorId = IgnitePlanner.this.cluster().createCorrel();
                    CorrelationId oldCorId = this.replaceMap.put(corId, newCorId);
                    try {
                        correlate = correlate.copy(correlate.getTraitSet(), correlate.getLeft(), correlate.getRight(), newCorId, correlate.getRequiredColumns(), correlate.getJoinType());
                        RelNode relNode = this.visitLeftAndRightCorrelateHands(correlate, corId);
                        return relNode;
                    }
                    finally {
                        if (oldCorId == null) {
                            this.replaceMap.remove(corId);
                        } else {
                            this.replaceMap.put(corId, oldCorId);
                        }
                    }
                }
                this.usedSet.add(corId);
                return this.visitLeftAndRightCorrelateHands(correlate, corId);
            }

            public RelNode visit(RelNode other) {
                RelNode next = super.visit(other);
                return this.replaceMap.isEmpty() ? next : next.accept(this.rexShuttle);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RelNode visitLeftAndRightCorrelateHands(LogicalCorrelate correlate, CorrelationId corId) {
                LogicalCorrelate node = correlate;
                node = this.visitChild((RelNode)node, 0, correlate.getLeft());
                this.removeMap.compute(corId, (k, v) -> v == null ? 1 : v + 1);
                try {
                    node = this.visitChild((RelNode)node, 1, correlate.getRight());
                }
                finally {
                    this.removeMap.compute(corId, (k, v) -> v == 1 ? null : Integer.valueOf(v - 1));
                }
                return node;
            }
        };
        return relShuttle.visit(rel);
    }

    private IgniteSqlToRelConvertor sqlToRelConverter(SqlValidator validator, CalciteCatalogReader reader, SqlToRelConverter.Config config) {
        return new IgniteSqlToRelConvertor(this, validator, (Prepare.CatalogReader)reader, this.cluster(), this.convertletTbl, config);
    }

    public IgniteSqlToRelConvertor sqlToRelConverter() {
        return this.sqlToRelConverter(this.validator(), this.catalogReader, this.sqlToRelConverterCfg);
    }

    public void disableRule(String ruleName) {
        this.ctx.disableRule(ruleName);
    }

    public void disableRules(Collection<String> ruleNamesToDisable) {
        if (CollectionUtils.nullOrEmpty(ruleNamesToDisable)) {
            return;
        }
        ruleNamesToDisable.forEach(this::disableRule);
    }

    static {
        IgnitePlanner.warmup();
    }

    private static class VolcanoPlannerExt
    extends VolcanoPlanner {
        private static final IgniteLogger LOG = Loggers.forClass(IgnitePlanner.class);
        private final long startTs;

        protected VolcanoPlannerExt(RelOptCostFactory costFactory, Context externalCtx, long startTs) {
            super(costFactory, externalCtx);
            this.setTopDownOpt(true);
            this.startTs = startTs;
        }

        public RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
            return mq.getCumulativeCost(rel);
        }

        public void checkCancel() {
            PlanningContext ctx = (PlanningContext)this.getContext().unwrap(PlanningContext.class);
            long timeout = ctx.plannerTimeout();
            if (timeout > 0L && FastTimestamps.coarseCurrentTimeMillis() - this.startTs > timeout) {
                LOG.debug("Planning of a query aborted due to planner timeout threshold is reached [timeout={}, query={}]", new Object[]{timeout, ctx.query()});
                ctx.abortByTimeout();
                this.cancelFlag.set(true);
            }
            super.checkCancel();
        }
    }
}

