/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.lang.reflect.Method;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdDistinctRowCount;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NumberUtil;
import org.jetbrains.annotations.Nullable;

public class IgniteMdDistinctRowCount
extends RelMdDistinctRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.DISTINCT_ROW_COUNT.method, (MetadataHandler)new IgniteMdDistinctRowCount());

    public Double getDistinctRowCount(Aggregate rel, RelMetadataQuery mq, ImmutableBitSet groupKey, @Nullable RexNode predicate) {
        return rel.estimateRowCount(mq);
    }

    public Double getDistinctRowCount(RelSubset rel, RelMetadataQuery mq, ImmutableBitSet groupKey, RexNode predicate) {
        RelNode best = rel.getBest();
        if (best != null) {
            return mq.getDistinctRowCount(best, groupKey, predicate);
        }
        Double d = null;
        for (RelNode r2 : rel.getRels()) {
            try {
                Double d2 = mq.getDistinctRowCount(r2, groupKey, predicate);
                d = NumberUtil.min(d, (Double)d2);
            }
            catch (CyclicMetadataException cyclicMetadataException) {}
        }
        return d;
    }
}

