/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessage;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class QueryCloseMessageDeserializer
implements MessageDeserializer<QueryCloseMessage> {
    private final QueryCloseMessageBuilder msg;

    QueryCloseMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryCloseMessage();
    }

    public Class<QueryCloseMessage> klass() {
        return QueryCloseMessage.class;
    }

    public QueryCloseMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SqlQueryMessagesTypeInfos.queryCloseMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 1: {
                UUID tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.queryId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryCloseMessage.class);
    }
}

