/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.List;
import org.apache.ignite.internal.lang.Debuggable;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.RunnableX;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractNode<RowT>
implements Node<RowT> {
    static final int NOT_WAITING = -1;
    public static final int MODIFY_BATCH_SIZE = 100;
    static final int IO_BATCH_SIZE = 256;
    static final int IO_BATCH_CNT = 4;
    protected final int inBufSize;
    private final ExecutionContext<RowT> ctx;
    private volatile Thread thread;
    private Downstream<RowT> downstream;
    private boolean closed;
    private List<Node<RowT>> sources;

    protected AbstractNode(ExecutionContext<RowT> ctx) {
        this.ctx = ctx;
        this.inBufSize = ctx.bufferSize();
    }

    @Override
    public ExecutionContext<RowT> context() {
        return this.ctx;
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        this.sources = sources;
        for (int i = 0; i < sources.size(); ++i) {
            sources.get(i).onRegister(this.requestDownstream(i));
        }
    }

    @Override
    public List<Node<RowT>> sources() {
        return this.sources;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.closeInternal();
        if (!CollectionUtils.nullOrEmpty(this.sources())) {
            this.sources().forEach(Commons::closeQuiet);
        }
    }

    @Override
    public void rewind() {
        this.rewindInternal();
        if (!CollectionUtils.nullOrEmpty(this.sources())) {
            this.sources().forEach(Node::rewind);
        }
    }

    @Override
    public void execute(RunnableX task) {
        if (this.isClosed()) {
            return;
        }
        this.context().execute(() -> {
            if (this.isClosed()) {
                return;
            }
            this.checkState();
            task.run();
        }, this::onError);
    }

    @Override
    public void onRegister(Downstream<RowT> downstream) {
        this.downstream = downstream;
    }

    public void onError(Throwable e) {
        Downstream<RowT> downstream = this.downstream();
        assert (downstream != null);
        try {
            downstream.onError(e);
        }
        finally {
            Commons.closeQuiet(this);
        }
    }

    protected void closeInternal() {
        this.closed = true;
    }

    protected abstract void rewindInternal();

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkState() {
        if (!IgniteUtils.assertionsEnabled()) {
            return;
        }
        Thread currentedThread = Thread.currentThread();
        AbstractNode abstractNode = this;
        synchronized (abstractNode) {
            if (this.thread == null) {
                this.thread = currentedThread;
            } else assert (this.thread == currentedThread) : IgniteStringFormatter.format((String)"expThread={}, actThread={}, executionId={}, fragmentId={}", (Object[])new Object[]{this.thread.getName(), currentedThread.getName(), this.context().executionId(), this.context().fragmentId()});
        }
    }

    protected abstract Downstream<RowT> requestDownstream(int var1);

    @Override
    public Downstream<RowT> downstream() {
        return this.downstream;
    }

    protected void acquireRow(RowT row) {
        assert (row != null);
        if (this.context().memoryContext().tryAcquire(row)) {
            return;
        }
        this.context().storageFactory().spillToDisk();
        this.context().memoryContext().acquire(row);
    }

    protected void releaseRow(RowT row) {
        assert (row != null);
        this.context().memoryContext().release(row);
    }

    protected final void releaseNullableRow(@Nullable RowT row) {
        if (row == null) {
            return;
        }
        this.releaseRow(row);
    }

    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName());
    }

    @TestOnly
    public void dumpState(IgniteStringBuilder writer, String indent) {
        writer.app(indent);
        this.dumpDebugInfo0(writer);
        writer.nl();
        if (this.sources != null) {
            writer.app(indent).app("Sources: ").nl();
            Debuggable.dumpState((IgniteStringBuilder)writer, (String)Debuggable.childIndentation((String)indent), this.sources);
        }
    }
}

