/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashTable;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowStorageFactory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.BoundedSortedRowQueueImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.RowHashJoinIndexImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.RowHashTableImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.RowListImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.RowQueueColumnlessImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.RowQueueImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.RowSetImpl;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.SortedRowQueueImpl;
import org.apache.ignite.internal.type.NativeType;

public class RowStorageFactoryImpl<RowT>
implements RowStorageFactory<RowT> {
    private final List<ManuallyCloseable> structsToClose = new ArrayList<ManuallyCloseable>();
    private final MemoryContext<RowT> memoryContext;

    public RowStorageFactoryImpl(MemoryContext<RowT> memoryContext) {
        this.memoryContext = memoryContext;
    }

    @Override
    public RowList<RowT> list(RowHandler.RowFactory<RowT> rowFactory) {
        return this.register(new RowListImpl<RowT>(this.memoryContext));
    }

    @Override
    public RowList<RowT> list(RowHandler.RowFactory<RowT> rowFactory, int initialCapacity) {
        return this.register(new RowListImpl<RowT>(this.memoryContext, initialCapacity));
    }

    @Override
    public RowQueue<RowT> queue(RowHandler.RowFactory<RowT> rowFactory, int initialCapacity) {
        boolean columnlessStore = rowFactory.columnsCount() == 0;
        return this.register(columnlessStore ? new RowQueueColumnlessImpl() : new RowQueueImpl<RowT>(this.memoryContext, initialCapacity));
    }

    @Override
    public RowQueue<RowT> priorityQueue(RowHandler.RowFactory<RowT> rowFactory, Comparator<RowT> valueComparator, Comparator<ByteBuffer> tupleComp) {
        return this.register(new SortedRowQueueImpl<RowT>(this.memoryContext, valueComparator));
    }

    @Override
    public RowQueue<RowT> boundedPriorityQueue(RowHandler.RowFactory<RowT> rowFactory, int capacity, Comparator<RowT> valueComparator, Comparator<ByteBuffer> tupleComp) {
        return this.register(new BoundedSortedRowQueueImpl<RowT>(this.memoryContext, capacity, valueComparator));
    }

    @Override
    public <K, V> RowHashTable<K, V> hashTable(KeyValueCodec<K, V> keyValueCodec) {
        return this.register(new RowHashTableImpl(this.memoryContext));
    }

    @Override
    public <E> RowSet<E> hashSet(Class<E> elementClass, NativeType elementType) {
        return this.register(new RowSetImpl(this.memoryContext));
    }

    @Override
    public <E> RowSet<E> hashSet(KeyValueCodec<E, Void> codec) {
        return this.register(new RowSetImpl(this.memoryContext));
    }

    @Override
    public RowHashJoinIndex<RowT, RowT> hashJoinIndex(RowHandler.RowFactory<RowT> rowFactory, int[] keyFields) {
        return this.register(new RowHashJoinIndexImpl<RowT>(this.memoryContext, rowFactory, keyFields));
    }

    @Override
    public synchronized void close() throws Exception {
        for (ManuallyCloseable struct : this.structsToClose) {
            struct.close();
        }
        this.structsToClose.clear();
    }

    protected synchronized <T extends ManuallyCloseable> T register(T dataStructure) {
        this.structsToClose.add(dataStructure);
        return dataStructure;
    }
}

