/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryTracker;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.BaseFileIoTracker;

public class FileIoTrackerImpl
extends BaseFileIoTracker {
    private final AtomicInteger fdCounter = new AtomicInteger();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicLong writes = new AtomicLong();
    private final AtomicLong reads = new AtomicLong();

    public FileIoTrackerImpl(MemoryTracker memoryTracker) {
        super(memoryTracker);
    }

    @Override
    public void incrementOpenFds() {
        this.fdCounter.incrementAndGet();
    }

    @Override
    public void decrementOpenFds() {
        this.fdCounter.decrementAndGet();
    }

    @Override
    public int openedFds() {
        return this.fdCounter.get();
    }

    @Override
    public void addBytesWritten(long count) {
        this.bytesWritten.addAndGet(count);
        this.writes.incrementAndGet();
    }

    @Override
    public void addBytesRead(long count) {
        this.bytesRead.addAndGet(count);
        this.reads.incrementAndGet();
    }

    @Override
    public long totalBytesWritten() {
        return this.bytesWritten.get();
    }

    @Override
    public long totalBytesRead() {
        return this.bytesRead.get();
    }

    @Override
    public long totalWriteOperations() {
        return this.writes.get();
    }

    @Override
    public long totalReadOperations() {
        return this.reads.get();
    }
}

