/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalCollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;

public final class DataDirectory {
    private final Path directory;
    private boolean created;

    public DataDirectory(Path directory) {
        this.directory = Objects.requireNonNull(directory, "directory");
    }

    public Path createFile(String fileNamePrefix) {
        Objects.requireNonNull(fileNamePrefix, fileNamePrefix);
        Path file = this.directory.resolve(ExternalCollectionUtils.generateFilename(fileNamePrefix));
        file.toFile().deleteOnExit();
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException ignore) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Failed to create directory for spill files.");
        }
        this.created = true;
        return file;
    }

    public boolean deleteIfExists() {
        if (this.created) {
            try {
                return Files.deleteIfExists(this.directory);
            }
            catch (IOException ignore) {
                return false;
            }
        }
        return true;
    }
}

