/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverterFactory;
import org.apache.ignite.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite.internal.table.IndexScanCriteria;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.OperationContext;
import org.apache.ignite.internal.table.TxContext;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.subscription.TransformingPublisher;
import org.jetbrains.annotations.Nullable;

public class ScannableTableImpl
implements ScannableTable {
    private final InternalTable internalTable;
    private final TableRowConverterFactory converterFactory;

    public ScannableTableImpl(InternalTable internalTable, TableRowConverterFactory converterFactory) {
        this.internalTable = internalTable;
        this.converterFactory = converterFactory;
    }

    @Override
    public <RowT> Flow.Publisher<RowT> scan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowHandler.RowFactory<RowT> rowFactory, int @Nullable [] requiredColumns) {
        TxContext txContext = ScannableTableImpl.transactionalContextFrom(ctx.txAttributes(), partWithConsistencyToken.enlistmentConsistencyToken());
        int partId = partWithConsistencyToken.partId();
        Flow.Publisher pub = this.internalTable.scan(partId, ctx.localNode(), OperationContext.create((TxContext)txContext));
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexRangeScan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowHandler.RowFactory<RowT> rowFactory, int indexId, List<String> columns, @Nullable RangeCondition<RowT> cond, int @Nullable [] requiredColumns) {
        BinaryTuplePrefix upper;
        BinaryTuplePrefix lower;
        TxContext txContext = ScannableTableImpl.transactionalContextFrom(ctx.txAttributes(), partWithConsistencyToken.enlistmentConsistencyToken());
        RowHandler<RowT> handler = rowFactory.handler();
        int flags = 0;
        if (cond == null) {
            flags = 3;
            lower = null;
            upper = null;
        } else {
            lower = ScannableTableImpl.toBinaryTuplePrefix(columns.size(), handler, cond.lower());
            upper = ScannableTableImpl.toBinaryTuplePrefix(columns.size(), handler, cond.upper());
            flags |= cond.lowerInclude() ? 1 : 0;
            flags |= cond.upperInclude() ? 2 : 0;
        }
        int partId = partWithConsistencyToken.partId();
        Flow.Publisher pub = this.internalTable.scan(partId, ctx.localNode(), indexId, (IndexScanCriteria)IndexScanCriteria.range((BinaryTuplePrefix)lower, (BinaryTuplePrefix)upper, (int)flags), OperationContext.create((TxContext)txContext));
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexLookup(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowHandler.RowFactory<RowT> rowFactory, int indexId, List<String> columns, RowT key, int @Nullable [] requiredColumns) {
        TxContext txContext = ScannableTableImpl.transactionalContextFrom(ctx.txAttributes(), partWithConsistencyToken.enlistmentConsistencyToken());
        RowHandler<RowT> handler = rowFactory.handler();
        BinaryTuple keyTuple = handler.toBinaryTuple(key);
        assert (keyTuple.elementCount() == columns.size()) : IgniteStringFormatter.format((String)"Key should contain exactly {} fields, but was {}", (Object[])new Object[]{columns.size(), handler.toString(key)});
        int partId = partWithConsistencyToken.partId();
        Flow.Publisher pub = this.internalTable.scan(partId, ctx.localNode(), indexId, (IndexScanCriteria)IndexScanCriteria.lookup((BinaryTuple)keyTuple), OperationContext.create((TxContext)txContext));
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> CompletableFuture<RowT> primaryKeyLookup(ExecutionContext<RowT> ctx, InternalTransaction tx, RowHandler.RowFactory<RowT> rowFactory, RowT key, int @Nullable [] requiredColumns) {
        assert (tx != null);
        TableRowConverter converter = this.converterFactory.create(requiredColumns);
        BinaryRowEx keyRow = converter.toKeyRow(ctx, key);
        return this.internalTable.get(keyRow, tx).thenApply(tableRow -> {
            if (tableRow == null) {
                return null;
            }
            return converter.toRow(ctx, (BinaryRow)tableRow, rowFactory);
        });
    }

    @Override
    public CompletableFuture<Long> estimatedSize() {
        return this.internalTable.estimatedSize();
    }

    @Nullable
    private static <RowT> BinaryTuplePrefix toBinaryTuplePrefix(int searchBoundSize, RowHandler<RowT> handler, @Nullable RowT prefix) {
        if (prefix == null || handler.columnCount(prefix) == 0) {
            return null;
        }
        assert (searchBoundSize >= handler.columnCount(prefix)) : "Invalid range condition";
        return BinaryTuplePrefix.fromBinaryTuple((int)searchBoundSize, (BinaryTuple)handler.toBinaryTuple(prefix));
    }

    private static TxContext transactionalContextFrom(TxAttributes txAttributes, long enlistmentConsistencyToken) {
        if (txAttributes.readOnly()) {
            HybridTimestamp timestamp = txAttributes.time();
            assert (timestamp != null);
            return TxContext.readOnly((UUID)txAttributes.id(), (UUID)txAttributes.coordinatorId(), (HybridTimestamp)timestamp);
        }
        ReplicationGroupId commitPartition = txAttributes.commitPartition();
        assert (commitPartition != null);
        return TxContext.readWrite((UUID)txAttributes.id(), (UUID)txAttributes.coordinatorId(), (ReplicationGroupId)commitPartition, (long)enlistmentConsistencyToken);
    }
}

