/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.exec.ExecutableSequence;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.apache.ignite.table.KeyValueView;
import org.jetbrains.annotations.Nullable;

class ExecutableSequenceImpl
implements ExecutableSequence {
    private static final long ID = 1L;
    private final Lock lock = new ReentrantLock();
    private final String name;
    private final int sequenceId;
    private final long increment;
    private final long minValue;
    private final long maxValue;
    private final long start;
    private final long cacheValue;
    private final KeyValueView<Long, Long> view;
    private final CachedSequence cache;

    ExecutableSequenceImpl(String name, int sequenceId, long increment, long minValue, long maxValue, long start, long cacheValue, KeyValueView<Long, Long> view) {
        this.name = name;
        this.sequenceId = sequenceId;
        this.increment = increment;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.start = start;
        this.cacheValue = cacheValue;
        this.view = view;
        this.cache = new CachedSequence();
    }

    @Override
    public long nextVal() {
        this.lock.lock();
        try {
            if (this.cacheValue > 1L) {
                long l = this.cache.nextValue();
                return l;
            }
            long l = this.nextValue();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setVal(long newValue) {
        this.lock.lock();
        try {
            if (newValue < this.minValue || newValue > this.maxValue) {
                throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, IgniteStringFormatter.format((String)"value {} is out of bounds for sequence \"{}\" ({}..{})", (Object[])new Object[]{newValue, this.name, this.minValue, this.maxValue}));
            }
            this.view.put(null, (Object)1L, (Object)newValue);
            this.cache.reset();
            long l = newValue;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long currVal() {
        Long value = (Long)this.view.get(null, (Object)1L);
        if (value == null) {
            String msg = IgniteStringFormatter.format((String)"currval of sequence \"{}\" is not yet defined, use nextval first", (Object[])new Object[]{this.name});
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, msg);
        }
        return value;
    }

    private void validateNext(long value) {
        if (this.increment > 0L && value > this.maxValue) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, IgniteStringFormatter.format((String)"reached maximum value of sequence \"{}\" (max={}, val={})", (Object[])new Object[]{this.name, this.maxValue, value}));
        }
        if (this.increment < 0L && value < this.minValue) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, IgniteStringFormatter.format((String)"reached minimum value of sequence \"{}\" (min={}, val={})", (Object[])new Object[]{this.name, this.minValue, value}));
        }
    }

    private long nextValue() {
        return this.advance().next;
    }

    private Pair advance() {
        Long last = (Long)this.view.get(null, (Object)1L);
        if (last == null) {
            return Objects.requireNonNullElseGet(this.tryInit(), this::advance);
        }
        long next = this.calculateNextValue(last);
        int retry = 0;
        while (retry++ < 50) {
            this.validateNext(next);
            if (this.view.replace(null, (Object)1L, (Object)last, (Object)next)) {
                return new Pair(last, next);
            }
            last = (Long)this.view.get(null, (Object)1L);
            assert (last != null);
            next = this.calculateNextValue(last);
        }
        throw new IllegalStateException(IgniteStringFormatter.format((String)"Failed to retrieve nextval for sequence \"{}\" with id {}", (Object[])new Object[]{this.name, this.sequenceId}));
    }

    private long calculateNextValue(long last) {
        return last + this.increment * this.cacheValue;
    }

    @Nullable
    private Pair tryInit() {
        long initial = this.cacheValue > 1L ? this.start + this.increment * (this.cacheValue - 1L) : this.start;
        this.validateNext(initial);
        if (this.view.putIfAbsent(null, (Object)1L, (Object)initial)) {
            return new Pair(null, initial);
        }
        return null;
    }

    private class CachedSequence {
        private boolean initialized;
        @Nullable
        private Long value;
        private Long bound;

        private CachedSequence() {
        }

        long nextValue() {
            if (!this.initialized || this.isExceed()) {
                Pair v = ExecutableSequenceImpl.this.advance();
                this.value = v.last;
                this.bound = v.next;
                this.initialized = true;
            }
            if (this.value == null) {
                this.value = ExecutableSequenceImpl.this.start;
                return this.value;
            }
            this.value = this.value + ExecutableSequenceImpl.this.increment;
            ExecutableSequenceImpl.this.validateNext(this.value);
            return this.value;
        }

        void reset() {
            this.initialized = false;
        }

        boolean isExceed() {
            long next = Objects.requireNonNullElse(this.value, ExecutableSequenceImpl.this.start) + ExecutableSequenceImpl.this.increment;
            return ExecutableSequenceImpl.this.increment > 0L && next > this.bound || ExecutableSequenceImpl.this.increment < 0L && next < this.bound;
        }
    }

    private static class Pair {
        @Nullable
        final Long last;
        final long next;

        Pair(@Nullable Long last, long next) {
            this.last = last;
            this.next = next;
        }
    }
}

