/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.ToIntFunction;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.exec.exp.IgniteSqlFunctions;
import org.apache.ignite.internal.sql.engine.prepare.OutOfRangeLiteralComparisonReductionShuttle;
import org.apache.ignite.internal.sql.engine.prepare.bounds.ExactBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.MultiBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.RangeBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;
import org.apache.ignite.internal.sql.engine.util.IgniteSqlDateTimeUtils;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class RexUtils {
    public static final int MAX_SEARCH_BOUNDS_COMPLEXITY = 100;
    private static final EnumSet<SqlKind> HASH_SEARCH_OPS = EnumSet.of(SqlKind.EQUALS, SqlKind.IS_NOT_DISTINCT_FROM);
    private static final Set<SqlKind> TREE_INDEX_COMPARISON = EnumSet.of(SqlKind.SEARCH, new SqlKind[]{SqlKind.IS_NULL, SqlKind.IS_NOT_NULL, SqlKind.EQUALS, SqlKind.IS_NOT_DISTINCT_FROM, SqlKind.LESS_THAN, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL});

    public static RexBuilder builder(RelNode rel) {
        return RexUtils.builder(rel.getCluster());
    }

    public static RexBuilder builder(RelOptCluster cluster) {
        return cluster.getRexBuilder();
    }

    public static RexExecutor executor(RelNode rel) {
        return RexUtils.executor(rel.getCluster());
    }

    public static RexExecutor executor(RelOptCluster cluster) {
        return (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
    }

    public static boolean isIdentity(List<? extends RexNode> projects, RelDataType inputRowType) {
        if (inputRowType.getFieldCount() != projects.size()) {
            return false;
        }
        List fields = inputRowType.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            if (!(projects.get(i) instanceof RexLocalRef)) {
                return false;
            }
            RexSlot ref = (RexSlot)projects.get(i);
            if (ref.getIndex() != i) {
                return false;
            }
            if (RelOptUtil.eq((String)"t1", (RelDataType)projects.get(i).getType(), (String)"t2", (RelDataType)((RelDataTypeField)fields.get(i)).getType(), (Litmus)Litmus.IGNORE)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static RexNode tryToDnf(RexBuilder rexBuilder, RexNode node, int maxOrNodes) {
        DnfHelper helper = new DnfHelper(Commons.rexBuilder(), maxOrNodes);
        try {
            return helper.toDnf(node);
        }
        catch (Util.FoundOne e) {
            return null;
        }
    }

    @Nullable
    public static List<SearchBounds> buildSortedSearchBounds(RelOptCluster cluster, RelCollation collation, @Nullable RexNode condition, RelDataType rowType, @Nullable ImmutableIntList requiredColumns) {
        return RexUtils.buildSearchBounds(true, cluster, collation, condition, rowType, requiredColumns);
    }

    @Nullable
    public static List<SearchBounds> buildHashSearchBounds(RelOptCluster cluster, RelCollation collation, @Nullable RexNode condition, RelDataType rowType, @Nullable ImmutableIntList requiredColumns) {
        List<SearchBounds> bounds = RexUtils.buildSearchBounds(false, cluster, collation, condition, rowType, requiredColumns);
        if (bounds == null) {
            return null;
        }
        if (bounds.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        return bounds;
    }

    public static List<SearchBounds> buildHashSearchBounds(RelOptCluster cluster, RexNode condition, RelDataType rowType, @Nullable ImmutableBitSet requiredColumns) {
        Int2ObjectMap.Entry fld;
        List collFldPreds;
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Int2ObjectMap<List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (CollectionUtils.nullOrEmpty(fieldsToPredicates)) {
            return null;
        }
        List<SearchBounds> bounds = null;
        List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        Mapping mapping = null;
        if (requiredColumns != null) {
            mapping = Commons.trimmingMapping(types.size(), requiredColumns);
        }
        ObjectIterator objectIterator = fieldsToPredicates.int2ObjectEntrySet().iterator();
        while (objectIterator.hasNext() && !CollectionUtils.nullOrEmpty((Collection)(collFldPreds = (List)(fld = (Int2ObjectMap.Entry)objectIterator.next()).getValue()))) {
            for (RexCall pred : collFldPreds) {
                if (!pred.isA(HASH_SEARCH_OPS)) {
                    return null;
                }
                if (bounds == null) {
                    bounds = Arrays.asList(new SearchBounds[types.size()]);
                }
                int fldIdx = mapping != null ? mapping.getSourceOpt(fld.getIntKey()) : fld.getIntKey();
                bounds.set(fldIdx, new ExactBounds((RexNode)pred, (RexNode)pred.operands.get(1)));
            }
        }
        return bounds;
    }

    @Nullable
    private static List<SearchBounds> buildSearchBounds(boolean allowRange, RelOptCluster cluster, RelCollation collation, @Nullable RexNode condition, RelDataType rowType, @Nullable ImmutableIntList requiredColumns) {
        SearchBounds fldBounds;
        RelFieldCollation fieldCollation;
        int collFldIdx;
        List collFldPreds;
        if (condition == null) {
            return null;
        }
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Int2ObjectMap<List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (CollectionUtils.nullOrEmpty(fieldsToPredicates)) {
            return null;
        }
        if (collation == null || collation.isDefault()) {
            IntArrayList fields = new IntArrayList(fieldsToPredicates.size());
            IntArrayList lastFields = new IntArrayList(fieldsToPredicates.size());
            fieldsToPredicates.int2ObjectEntrySet().forEach(entry -> (((List)entry.getValue()).stream().anyMatch(v -> v.getOperator().getKind() == SqlKind.EQUALS) ? fields : lastFields).add(entry.getIntKey()));
            fields.addAll((IntList)lastFields);
            collation = TraitUtils.createCollation((IntList)fields);
        }
        List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        Mappings.IdentityMapping mapping = requiredColumns == null ? Mappings.createIdentity((int)types.size()) : Commons.projectedMapping(types.size(), requiredColumns);
        List<SearchBounds> bounds = Arrays.asList(new SearchBounds[collation.getFieldCollations().size()]);
        boolean boundsEmpty = true;
        int prevComplexity = 1;
        List fieldCollations = collation.getFieldCollations();
        for (int i = 0; i < fieldCollations.size() && !CollectionUtils.nullOrEmpty((Collection)(collFldPreds = (List)fieldsToPredicates.get(collFldIdx = (fieldCollation = (RelFieldCollation)fieldCollations.get(i)).getFieldIndex()))) && (fldBounds = RexUtils.createBounds(fieldCollation, collFldPreds, cluster, (RelDataType)types.get(collFldIdx = mapping.getSourceOpt(collFldIdx)), prevComplexity, allowRange)) != null; ++i) {
            boundsEmpty = false;
            bounds.set(i, fldBounds);
            if (fldBounds instanceof MultiBounds) {
                prevComplexity *= ((MultiBounds)fldBounds).bounds().size();
                if (((MultiBounds)fldBounds).bounds().stream().anyMatch(b -> b.type() != SearchBounds.Type.EXACT)) break;
            }
            if (fldBounds.type() == SearchBounds.Type.RANGE) break;
        }
        return boundsEmpty ? null : bounds;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private static SearchBounds createBounds(@Nullable RelFieldCollation fc, List<RexCall> collFldPreds, RelOptCluster cluster, RelDataType fldType, int prevComplexity, boolean allowRange) {
        builder = RexUtils.builder(cluster);
        nullValue = builder.makeNullLiteral(fldType);
        upperCond = null;
        lowerCond = null;
        upperBound = null;
        lowerBound = null;
        upperInclude = true;
        lowerInclude = true;
        collFldPreds.sort(Comparator.comparingInt((ToIntFunction<RexCall>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$createBounds$3(org.apache.calcite.rex.RexCall ), (Lorg/apache/calcite/rex/RexCall;)I)()));
        block5: for (RexCall pred : collFldPreds) {
            val = null;
            ref = (RexNode)pred.getOperands().get(0);
            if (RexUtils.isBinaryComparison((RexNode)pred)) {
                val = (RexNode)pred.getOperands().get(1);
            }
            op = pred.getOperator();
            if (op.kind == SqlKind.EQUALS || op.kind == SqlKind.IS_NOT_DISTINCT_FROM) {
                if (!RexUtils.$assertionsDisabled && val == null) {
                    throw new AssertionError();
                }
                return new ExactBounds((RexNode)pred, val);
            }
            if (op.kind == SqlKind.IS_NULL) {
                return new ExactBounds((RexNode)pred, (RexNode)nullValue);
            }
            if (op.kind == SqlKind.OR) {
                orBounds = new ArrayList<SearchBounds>();
                curComplexity = 0;
                for (RexNode operand : pred.getOperands()) {
                    opBounds = RexUtils.createBounds(fc, Collections.singletonList((RexCall)operand), cluster, fldType, prevComplexity, allowRange);
                    if (opBounds instanceof MultiBounds) {
                        curComplexity += ((MultiBounds)opBounds).bounds().size();
                        orBounds.addAll(((MultiBounds)opBounds).bounds());
                    } else if (opBounds != null) {
                        ++curComplexity;
                        orBounds.add(opBounds);
                    }
                    if (opBounds != null && curComplexity <= 100) continue;
                    orBounds = null;
                    break;
                }
                if (orBounds == null) continue;
                return new MultiBounds((RexNode)pred, orBounds);
            }
            if (op.kind == SqlKind.SEARCH) {
                sarg = (Sarg)((RexLiteral)pred.operands.get(1)).getValueAs(Sarg.class);
                bounds = RexUtils.expandSargToBounds(fc, cluster, fldType, prevComplexity, sarg, ref, allowRange);
                if (bounds == null) continue;
                if (bounds.size() == 1) {
                    if (bounds.get(0) instanceof RangeBounds && collFldPreds.size() > 1) {
                        ascDir = fc.getDirection().isDescending() == false;
                        rangeBounds = (RangeBounds)bounds.get(0);
                        if (rangeBounds.lowerBound() != null) {
                            if (lowerBound != null && lowerBound != nullValue) {
                                lowerBound = RexUtils.leastOrGreatest(builder, ascDir == false, lowerBound, rangeBounds.lowerBound());
                                lowerInclude |= rangeBounds.lowerInclude();
                            } else {
                                lowerBound = rangeBounds.lowerBound();
                                lowerInclude = rangeBounds.lowerInclude();
                            }
                            lowerCond = RexUtils.lessOrGreater(builder, ascDir == false, lowerInclude, ref, lowerBound);
                        }
                        if (rangeBounds.upperBound() == null) continue;
                        if (upperBound != null && upperBound != nullValue) {
                            upperBound = RexUtils.leastOrGreatest(builder, ascDir, upperBound, rangeBounds.upperBound());
                            upperInclude |= rangeBounds.upperInclude();
                        } else {
                            upperBound = rangeBounds.upperBound();
                            upperInclude = rangeBounds.upperInclude();
                        }
                        upperCond = RexUtils.lessOrGreater(builder, ascDir, upperInclude, ref, upperBound);
                        continue;
                    }
                    return bounds.get(0);
                }
                return new MultiBounds((RexNode)pred, bounds);
            }
            if (!allowRange) {
                return null;
            }
            lowerBoundBelow = fc.getDirection().isDescending() == false;
            includeBound = op.kind == SqlKind.GREATER_THAN_OR_EQUAL || op.kind == SqlKind.LESS_THAN_OR_EQUAL;
            lessCondition = false;
            switch (5.$SwitchMap$org$apache$calcite$sql$SqlKind[op.kind.ordinal()]) {
                case 4: 
                case 5: {
                    lessCondition = true;
                    lowerBoundBelow = lowerBoundBelow == false;
                }
                case 6: 
                case 7: {
                    if (!lowerBoundBelow) ** GOTO lbl87
                    if (lowerBound == null || lowerBound == nullValue) {
                        lowerCond = pred;
                        lowerBound = val;
                        lowerInclude = includeBound;
                    } else {
                        lowerBound = RexUtils.leastOrGreatest(builder, lessCondition, lowerBound, val);
                        lowerCond = RexUtils.lessOrGreater(builder, lessCondition, lowerInclude |= includeBound, ref, lowerBound);
                    }
                    ** GOTO lbl94
lbl87:
                    // 1 sources

                    if (upperBound == null || upperBound == nullValue) {
                        upperCond = pred;
                        upperBound = val;
                        upperInclude = includeBound;
                    } else {
                        upperBound = RexUtils.leastOrGreatest(builder, lessCondition, upperBound, val);
                        upperCond = RexUtils.lessOrGreater(builder, lessCondition, upperInclude |= includeBound, ref, upperBound);
                    }
                }
lbl94:
                // 5 sources

                case 8: {
                    if (fc.nullDirection == RelFieldCollation.NullDirection.FIRST && lowerBound == null) {
                        lowerCond = pred;
                        lowerBound = nullValue;
                        lowerInclude = false;
                        continue block5;
                    }
                    if (fc.nullDirection != RelFieldCollation.NullDirection.LAST || upperBound != null) continue block5;
                    upperCond = pred;
                    upperBound = nullValue;
                    upperInclude = false;
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unknown condition: " + op.kind));
        }
        if (lowerBound == null && upperBound == null) {
            return null;
        }
        if (!allowRange) {
            return null;
        }
        cond = lowerCond == null ? upperCond : (upperCond == null ? lowerCond : (upperCond == lowerCond ? lowerCond : builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{lowerCond, upperCond})));
        return new RangeBounds(cond, lowerBound, upperBound, lowerInclude, upperInclude);
    }

    @Nullable
    private static List<SearchBounds> expandSargToBounds(RelFieldCollation fc, RelOptCluster cluster, RelDataType fldType, int prevComplexity, Sarg<?> sarg, RexNode ref, boolean allowRange) {
        int complexity = prevComplexity * sarg.complexity();
        if (complexity > 100) {
            return null;
        }
        RexBuilder builder = RexUtils.builder(cluster);
        RexNode sargCond = (RexNode)RexUtil.sargRef((RexBuilder)builder, (RexNode)ref, sarg, (RelDataType)fldType, (RexUnknownAs)RexUnknownAs.UNKNOWN).accept((RexVisitor)new OutOfRangeLiteralComparisonReductionShuttle(builder));
        List disjunctions = RelOptUtil.disjunctions((RexNode)RexUtil.toDnf((RexBuilder)builder, (RexNode)sargCond));
        ArrayList<SearchBounds> bounds = new ArrayList<SearchBounds>(disjunctions.size());
        for (RexNode bound : disjunctions) {
            List conjunctions = RelOptUtil.conjunctions((RexNode)bound);
            ArrayList<RexCall> calls = new ArrayList<RexCall>(conjunctions.size());
            for (RexNode rexNode : conjunctions) {
                if (RexUtils.isSupportedTreeComparison(rexNode)) {
                    calls.add((RexCall)rexNode);
                    continue;
                }
                return null;
            }
            SearchBounds searchBounds = RexUtils.createBounds(fc, calls, cluster, fldType, complexity, allowRange);
            if (searchBounds == null) {
                return null;
            }
            bounds.add(searchBounds);
        }
        return bounds;
    }

    private static RexNode leastOrGreatest(RexBuilder builder, boolean least, RexNode arg0, RexNode arg1) {
        return builder.makeCall((SqlOperator)(least ? IgniteSqlOperatorTable.LEAST2 : IgniteSqlOperatorTable.GREATEST2), new RexNode[]{arg0, arg1});
    }

    private static RexNode lessOrGreater(RexBuilder builder, boolean less, boolean includeBound, RexNode arg0, RexNode arg1) {
        return builder.makeCall((SqlOperator)(less ? (includeBound ? SqlStdOperatorTable.LESS_THAN_OR_EQUAL : SqlStdOperatorTable.LESS_THAN) : (includeBound ? SqlStdOperatorTable.GREATER_THAN_OR_EQUAL : SqlStdOperatorTable.GREATER_THAN)), new RexNode[]{arg0, arg1});
    }

    private static Int2ObjectMap<List<RexCall>> mapPredicatesToFields(RexNode condition, RelOptCluster cluster) {
        List conjunctions = RelOptUtil.conjunctions((RexNode)condition);
        if (conjunctions.isEmpty()) {
            return Int2ObjectMaps.emptyMap();
        }
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap(conjunctions.size());
        for (RexNode rexNode : conjunctions) {
            Pair refPredicate = null;
            if (rexNode instanceof RexCall && rexNode.getKind() == SqlKind.OR) {
                List operands = ((RexCall)rexNode).getOperands();
                Integer ref = null;
                ArrayList<RexCall> preds = new ArrayList<RexCall>(operands.size());
                for (RexNode operand : operands) {
                    Pair<Integer, RexCall> operandRefPredicate = RexUtils.extractRefPredicate(operand, cluster);
                    if (operandRefPredicate == null) {
                        ref = null;
                        break;
                    }
                    if (ref == null) {
                        ref = (Integer)operandRefPredicate.getKey();
                    } else if (!ref.equals(operandRefPredicate.getKey())) {
                        ref = null;
                        break;
                    }
                    if (RexUtils.containsFieldAccess((RexNode)operandRefPredicate.getValue()).booleanValue()) {
                        ref = null;
                        break;
                    }
                    preds.add((RexCall)operandRefPredicate.getValue());
                }
                if (ref != null) {
                    refPredicate = Pair.of(ref, (Object)((RexCall)RexUtils.builder(cluster).makeCall(((RexCall)rexNode).getOperator(), preds)));
                }
            } else {
                refPredicate = RexUtils.extractRefPredicate(rexNode, cluster);
            }
            if (refPredicate == null) continue;
            List fldPreds = (List)res.computeIfAbsent((Object)((Integer)refPredicate.getKey()), k -> new ArrayList(conjunctions.size()));
            fldPreds.add((RexCall)refPredicate.getValue());
        }
        return res;
    }

    @Nullable
    private static Pair<Integer, RexCall> extractRefPredicate(RexNode rexNode, RelOptCluster cluster) {
        RexSlot ref;
        if (!RexUtils.isSupportedTreeComparison(rexNode = RexUtils.expandBooleanFieldComparison(rexNode, RexUtils.builder(cluster)))) {
            return null;
        }
        RexCall predCall = (RexCall)rexNode;
        if (RexUtils.isBinaryComparison(rexNode)) {
            ref = RexUtils.extractRefFromBinary(predCall);
            if (ref == null) {
                return null;
            }
            if (RexUtils.refOnTheRight(predCall)) {
                predCall = (RexCall)RexUtils.invert(RexUtils.builder(cluster), predCall);
            }
        } else {
            ref = RexUtils.extractRefFromOperand(predCall, 0);
            if (ref == null) {
                return null;
            }
        }
        return Pair.of((Object)ref.getIndex(), (Object)predCall);
    }

    private static Boolean containsFieldAccess(RexNode node) {
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                throw Util.FoundOne.NULL;
            }
        };
        try {
            node.accept((RexVisitor)v);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    private static RexNode invert(RexBuilder rexBuilder, RexCall call) {
        if (call.getOperator() == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) {
            return rexBuilder.makeCall(call.getOperator(), new RexNode[]{(RexNode)call.getOperands().get(1), (RexNode)call.getOperands().get(0)});
        }
        return RexUtil.invert((RexBuilder)rexBuilder, (RexCall)call);
    }

    private static RexNode expandBooleanFieldComparison(RexNode rexNode, RexBuilder builder) {
        if (rexNode instanceof RexSlot) {
            return builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexNode, builder.makeLiteral(true)});
        }
        if (rexNode instanceof RexCall && rexNode.getKind() == SqlKind.NOT && ((RexCall)rexNode).getOperands().get(0) instanceof RexSlot) {
            return builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)((RexCall)rexNode).getOperands().get(0), builder.makeLiteral(false)});
        }
        return rexNode;
    }

    @Nullable
    private static RexSlot extractRefFromBinary(RexCall call) {
        assert (RexUtils.isBinaryComparison((RexNode)call)) : "Unsupported RexNode is binary comparison: " + call;
        RexSlot leftRef = RexUtils.extractRefFromOperand(call, 0);
        RexNode rightOp = (RexNode)call.getOperands().get(1);
        if (leftRef != null) {
            return RexUtils.idxOpSupports(RexUtil.removeCast((RexNode)rightOp)) ? leftRef : null;
        }
        RexSlot rightRef = RexUtils.extractRefFromOperand(call, 1);
        RexNode leftOp = (RexNode)call.getOperands().get(0);
        if (rightRef != null) {
            return RexUtils.idxOpSupports(RexUtil.removeCast((RexNode)leftOp)) ? rightRef : null;
        }
        return null;
    }

    @Nullable
    private static RexSlot extractRefFromOperand(RexCall call, int operandNum) {
        assert (RexUtils.isSupportedTreeComparison((RexNode)call)) : "Unsupported RexNode is tree comparison: " + call;
        RexNode op = (RexNode)call.getOperands().get(operandNum);
        RelDataType operandType = op.getType();
        while (RexUtils.isLosslessCast(op)) {
            op = (RexNode)((RexCall)op).getOperands().get(0);
        }
        if (TypeUtils.needCastInSearchBounds(Commons.typeFactory(), operandType, op.getType())) {
            return null;
        }
        if (op instanceof RexSlot && !TypeUtils.needCastInSearchBounds(Commons.typeFactory(), op.getType(), operandType)) {
            return (RexSlot)op;
        }
        return null;
    }

    private static boolean refOnTheRight(RexCall predCall) {
        RexNode rightOp = (RexNode)predCall.getOperands().get(1);
        return (rightOp = RexUtil.removeCast((RexNode)rightOp)).isA(SqlKind.LOCAL_REF) || rightOp.isA(SqlKind.INPUT_REF);
    }

    public static boolean isBinaryComparison(RexNode exp) {
        return SqlKind.BINARY_COMPARISON.contains(exp.getKind()) && exp instanceof RexCall && ((RexCall)exp).getOperands().size() == 2;
    }

    private static boolean isSupportedTreeComparison(RexNode exp) {
        return TREE_INDEX_COMPARISON.contains(exp.getKind()) && exp instanceof RexCall;
    }

    private static boolean idxOpSupports(RexNode op) {
        return op instanceof RexLiteral || op instanceof RexDynamicParam || op instanceof RexFieldAccess || !RexUtils.containsRef(op);
    }

    public static boolean isNotNull(RexNode op) {
        if (op == null) {
            return false;
        }
        return !(op instanceof RexLiteral) || !((RexLiteral)op).isNull();
    }

    public static Mappings.TargetMapping inversePermutation(List<RexNode> nodes, RelDataType inputRowType, boolean local) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_FUNCTION, (int)nodes.size(), (int)inputRowType.getFieldCount());
        Class clazz = local ? RexLocalRef.class : RexInputRef.class;
        for (Ord node : Ord.zip(nodes)) {
            if (!clazz.isInstance(node.e)) continue;
            mapping.set(node.i, ((RexSlot)node.e).getIndex());
        }
        return mapping;
    }

    public static List<RexNode> replaceInputRefs(List<RexNode> nodes) {
        return InputRefReplacer.INSTANCE.apply(nodes);
    }

    public static RexNode replaceInputRefs(RexNode node) {
        return InputRefReplacer.INSTANCE.apply(node);
    }

    public static RexNode replaceLocalRefs(@Nullable RexNode node) {
        return LocalRefReplacer.INSTANCE.apply(node);
    }

    public static List<RexNode> replaceLocalRefs(List<RexNode> nodes) {
        return LocalRefReplacer.INSTANCE.apply(nodes);
    }

    public static boolean hasCorrelation(RexNode node) {
        return RexUtils.hasCorrelation(Collections.singletonList(node));
    }

    public static boolean hasCorrelation(List<RexNode> nodes) {
        try {
            RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

                public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                    throw new ControlFlowException();
                }
            };
            nodes.forEach(arg_0 -> RexUtils.lambda$hasCorrelation$5((RexVisitor)v, arg_0));
            return false;
        }
        catch (ControlFlowException e) {
            return true;
        }
    }

    public static Set<CorrelationId> extractCorrelationIds(RexNode node) {
        if (node == null) {
            return Collections.emptySet();
        }
        return RexUtils.extractCorrelationIds(Collections.singletonList(node));
    }

    public static Set<CorrelationId> extractCorrelationIds(List<RexNode> nodes) {
        final HashSet<CorrelationId> cors = new HashSet<CorrelationId>();
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                cors.add(correlVariable.id);
                return null;
            }
        };
        nodes.forEach(arg_0 -> RexUtils.lambda$extractCorrelationIds$6((RexVisitor)v, arg_0));
        return cors;
    }

    public static double doubleFromRex(RexNode n, double def) {
        try {
            if (n.isA(SqlKind.LITERAL)) {
                return ((Integer)((RexLiteral)n).getValueAs(Integer.class)).intValue();
            }
            return def;
        }
        catch (Exception e) {
            assert (false) : "Unable to extract value: " + e.getMessage();
            return def;
        }
    }

    public static IntSet notNullKeys(List<RexNode> row) {
        if (CollectionUtils.nullOrEmpty(row)) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet keys = new IntOpenHashSet();
        for (int i = 0; i < row.size(); ++i) {
            if (!RexUtils.isNotNull(row.get(i))) continue;
            keys.add(i);
        }
        return keys;
    }

    private static boolean containsRef(RexNode node) {
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitInputRef(RexInputRef inputRef) {
                throw Util.FoundOne.NULL;
            }

            public Void visitLocalRef(RexLocalRef locRef) {
                throw Util.FoundOne.NULL;
            }
        };
        try {
            node.accept((RexVisitor)v);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    @Nullable
    public static Object literalValue(DataContext context, RexLiteral literal, Class<?> type) {
        RelDataType dataType = literal.getType();
        if (literal.isNull()) {
            return null;
        }
        if (SqlTypeUtil.isNumeric((RelDataType)dataType)) {
            Number value = (Number)((Object)literal.getValue());
            return RexUtils.convertNumericLiteral(dataType, value, type);
        }
        Object val = literal.getValueAs(type);
        if (literal.getTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return IgniteSqlDateTimeUtils.subtractTimeZoneOffset((Long)val, (TimeZone)context.get(DataContext.Variable.TIME_ZONE.camelName));
        }
        return val;
    }

    private static Object convertNumericLiteral(RelDataType dataType, Number value, Class<?> type) {
        Primitive primitive = Primitive.ofBoxOr(type);
        assert (primitive != null || type == BigDecimal.class) : "Neither primitive nor BigDecimal: " + type;
        switch (dataType.getSqlTypeName()) {
            case TINYINT: {
                byte b = IgniteMath.convertToByteExact(value);
                if (primitive != null) {
                    return Primitives.convertPrimitiveExact(primitive, b);
                }
                return new BigDecimal(b);
            }
            case SMALLINT: {
                short s = IgniteMath.convertToShortExact(value);
                if (primitive != null) {
                    return Primitives.convertPrimitiveExact(primitive, s);
                }
                return new BigDecimal(s);
            }
            case INTEGER: {
                int i = IgniteMath.convertToIntExact(value);
                if (primitive != null) {
                    return Primitives.convertPrimitiveExact(primitive, i);
                }
                return new BigDecimal(i);
            }
            case BIGINT: {
                long l = IgniteMath.convertToLongExact(value);
                if (primitive != null) {
                    return Primitives.convertPrimitiveExact(primitive, l);
                }
                return new BigDecimal(l);
            }
            case REAL: 
            case FLOAT: {
                float r = IgniteMath.convertToFloatExact(value);
                if (primitive != null) {
                    return Primitives.convertPrimitiveExact(primitive, Float.valueOf(r));
                }
                return new BigDecimal(Float.toString(r));
            }
            case DOUBLE: {
                double d = IgniteMath.convertToDoubleExact(value);
                if (primitive != null) {
                    return Primitives.convertPrimitiveExact(primitive, d);
                }
                return new BigDecimal(Double.toString(d));
            }
            case DECIMAL: {
                BigDecimal bd = IgniteSqlFunctions.toBigDecimal(value, dataType.getPrecision(), dataType.getScale());
                assert (bd != null);
                if (primitive != null) {
                    return Primitives.convertPrimitiveExact(primitive, bd);
                }
                return bd;
            }
        }
        throw new IllegalStateException("Unexpected numeric type: " + dataType);
    }

    @Nullable
    public static List<SearchBounds> processSearchBounds(RexShuttle shuttle, @Nullable List<SearchBounds> searchBounds) {
        if (CollectionUtils.nullOrEmpty(searchBounds)) {
            return searchBounds;
        }
        ArrayList<SearchBounds> newSearchBounds = new ArrayList<SearchBounds>(searchBounds.size());
        boolean wasChanged = false;
        for (SearchBounds bound : searchBounds) {
            SearchBounds newBound = bound == null ? null : bound.accept(shuttle);
            newSearchBounds.add(newBound);
            wasChanged = wasChanged || newBound != bound;
        }
        return wasChanged ? newSearchBounds : searchBounds;
    }

    public static boolean isLosslessCast(RexNode node) {
        if (!node.isA(SqlKind.CAST)) {
            return false;
        }
        RelDataType source = ((RexNode)((RexCall)node).getOperands().get(0)).getType();
        RelDataType target = node.getType();
        if (source.getFamily() != target.getFamily()) {
            return false;
        }
        if (SqlTypeUtil.isExactNumeric((RelDataType)source) && target.getSqlTypeName() == SqlTypeName.DECIMAL) {
            int tp = target.getPrecision();
            int ts = target.getScale();
            int sp = source.getPrecision();
            int ss = source.getScale();
            return ts >= ss && tp - ts >= sp - ss;
        }
        if (SqlTypeFamily.CHARACTER.getTypeNames().contains(source.getSqlTypeName()) && SqlTypeFamily.CHARACTER.getTypeNames().contains(target.getSqlTypeName())) {
            return target.getSqlTypeName().compareTo((Enum)source.getSqlTypeName()) >= 0 && (source.getPrecision() <= target.getPrecision() || target.getPrecision() == -1);
        }
        if (source.getSqlTypeName() == target.getSqlTypeName() && SqlTypeUtil.isDatetime((RelDataType)source)) {
            return source.getPrecision() <= target.getPrecision();
        }
        return RexUtil.isLosslessCast((RelDataType)source, (RelDataType)target);
    }

    private static /* synthetic */ void lambda$extractCorrelationIds$6(RexVisitor v, RexNode rex) {
        rex.accept(v);
    }

    private static /* synthetic */ void lambda$hasCorrelation$5(RexVisitor v, RexNode n) {
        n.accept(v);
    }

    private static /* synthetic */ int lambda$createBounds$3(RexCall pred) {
        switch (pred.getOperator().getKind()) {
            case IS_NULL: {
                return 0;
            }
            case EQUALS: {
                return 1;
            }
            case IS_NOT_DISTINCT_FROM: {
                return 2;
            }
        }
        return 10;
    }

    static class DnfHelper {
        final RexBuilder rexBuilder;
        final int maxOrNodes;

        DnfHelper(RexBuilder rexBuilder, int maxOrNodes) {
            this.rexBuilder = rexBuilder;
            this.maxOrNodes = maxOrNodes;
        }

        private RexNode toDnf(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList operands = RexUtil.flattenAnd((Iterable)((RexCall)rex).getOperands());
                    RexNode head = (RexNode)operands.get(0);
                    RexNode headDnf = this.toDnf(head);
                    List headDnfs = RelOptUtil.disjunctions((RexNode)headDnf);
                    RexNode tail = this.and(Util.skip((List)operands));
                    RexNode tailDnf = this.toDnf(tail);
                    List tailDnfs = RelOptUtil.disjunctions((RexNode)tailDnf);
                    ArrayList<RexNode> list = new ArrayList<RexNode>(headDnfs.size() * tailDnfs.size());
                    for (RexNode h : headDnfs) {
                        for (RexNode t : tailDnfs) {
                            list.add(this.and((Iterable<? extends RexNode>)ImmutableList.of((Object)h, (Object)t)));
                        }
                    }
                    return this.or(list);
                }
                case OR: {
                    ImmutableList operands = RexUtil.flattenOr((Iterable)((RexCall)rex).getOperands());
                    List<RexNode> processed = this.toDnfs((List<RexNode>)operands);
                    return this.or(processed);
                }
                case NOT: {
                    RexNode arg = (RexNode)((RexCall)rex).getOperands().get(0);
                    switch (arg.getKind()) {
                        case NOT: {
                            return this.toDnf((RexNode)((RexCall)arg).getOperands().get(0));
                        }
                        case OR: {
                            List operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.and(Util.transform((List)RexUtil.flattenOr((Iterable)operands), RexUtil::not)));
                        }
                        case AND: {
                            List operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.or(Util.transform((List)RexUtil.flattenAnd((Iterable)operands), RexUtil::not)));
                        }
                    }
                    return rex;
                }
            }
            return rex;
        }

        private List<RexNode> toDnfs(List<RexNode> nodes) {
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            block3: for (RexNode node : nodes) {
                RexNode dnf = this.toDnf(node);
                switch (dnf.getKind()) {
                    case OR: {
                        list.addAll(((RexCall)dnf).getOperands());
                        continue block3;
                    }
                }
                list.add(dnf);
            }
            return list;
        }

        private RexNode and(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeConjunction((RexBuilder)this.rexBuilder, nodes);
        }

        private RexNode or(Iterable<? extends RexNode> nodes) {
            RexCall res0;
            RexNode res = RexUtil.composeDisjunction((RexBuilder)this.rexBuilder, nodes);
            if (res instanceof RexCall && (res0 = (RexCall)res).getOperands().size() > this.maxOrNodes) {
                throw Util.FoundOne.NULL;
            }
            return res;
        }
    }

    private static class InputRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new InputRefReplacer();

        private InputRefReplacer() {
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return new RexLocalRef(inputRef.getIndex(), inputRef.getType());
        }
    }

    private static class LocalRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new LocalRefReplacer();

        private LocalRefReplacer() {
        }

        public RexNode visitLocalRef(RexLocalRef inputRef) {
            return new RexInputRef(inputRef.getIndex(), inputRef.getType());
        }
    }

    public static class FaultyContext
    implements DataContext {
        public static final FaultyContext INSTANCE = new FaultyContext();

        public SchemaPlus getRootSchema() {
            throw new AssertionError((Object)"should not be called");
        }

        public JavaTypeFactory getTypeFactory() {
            throw new AssertionError((Object)"should not be called");
        }

        public QueryProvider getQueryProvider() {
            throw new AssertionError((Object)"should not be called");
        }

        @Nullable
        public Object get(String name) {
            throw new AssertionError((Object)("Should not call: [" + name + "] from current context."));
        }
    }
}

