/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql.rbac;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.apache.ignite.internal.sql.engine.sql.SqlShow;
import org.jetbrains.annotations.Nullable;

public class GridgainSqlShowPrivilegesGrants
extends SqlShow {
    private static final SqlSpecialOperator OPERATOR = new Operator();
    private final SqlIdentifier roleName;
    @Nullable
    private final SqlIdentifier selector;

    public GridgainSqlShowPrivilegesGrants(SqlParserPos pos, SqlIdentifier roleName, @Nullable SqlIdentifier selector) {
        super(pos);
        this.roleName = roleName;
        this.selector = selector;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.roleName, (Object)this.selector);
    }

    public SqlIdentifier roleName() {
        return this.roleName;
    }

    @Nullable
    public SqlIdentifier selector() {
        return this.selector;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SHOW");
        writer.keyword("PRIVILEGES");
        writer.keyword("GRANTS");
        writer.keyword("FOR");
        this.roleName.unparse(writer, leftPrec, rightPrec);
        if (this.selector != null) {
            writer.keyword("ON");
            this.selector.unparse(writer, leftPrec, rightPrec);
        }
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        public Operator() {
            super("SHOW PRIVILEGES GRANTS", SqlKind.OTHER);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlShowPrivilegesGrants(pos, (SqlIdentifier)operands[0], (SqlIdentifier)operands[1]);
        }
    }
}

