/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.exec.fsm.DdlBatchAware;
import org.apache.ignite.internal.sql.engine.sql.IgniteAbstractSqlAlterCache;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

@DdlBatchAware
public class IgniteSqlAlterCacheSetExpire
extends IgniteAbstractSqlAlterCache {
    private final SqlIdentifier expireColumn;

    public IgniteSqlAlterCacheSetExpire(SqlParserPos pos, boolean ifExists, SqlIdentifier tblName, SqlIdentifier expireColumn) {
        super(new Operator(ifExists), pos, tblName);
        this.expireColumn = expireColumn;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.expireColumn);
    }

    @Override
    protected void unparseAlterTableOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SET");
        writer.keyword("EXPIRE");
        writer.keyword("AT");
        this.expireColumn.unparse(writer, leftPrec, rightPrec);
    }

    public SqlIdentifier getExpireColumn() {
        return this.expireColumn;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("ALTER CACHE", SqlKind.ALTER_TABLE, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlAlterCacheSetExpire(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlIdentifier)operands[1]);
        }
    }
}

