/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite.internal.sql.engine.sql.fun.GridgainSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;

public class IgniteProject
extends Project
implements TraitsAwareIgniteRel {
    private static final String REL_TYPE_NAME = "Project";

    public IgniteProject(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, List.of(), input, projects, rowType);
    }

    public IgniteProject(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new IgniteProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        int key;
        int src;
        RelTraitSet in = inputTraits.get(0);
        IgniteDistribution distribution = TraitUtils.distribution(nodeTraits);
        if (distribution.getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)distribution)));
        }
        Mappings.TargetMapping mapping = IgniteProject.getPartialMapping((int)this.input.getRowType().getFieldCount(), (List)this.getProjects());
        ImmutableIntList keys = distribution.getKeys();
        IntArrayList srcKeys = new IntArrayList(keys.size());
        for (int i = 0; i < keys.size() && (src = mapping.getSourceOpt(key = keys.getInt(i))) != -1; ++i) {
            srcKeys.add(src);
        }
        if (srcKeys.size() == keys.size()) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)IgniteDistributions.clone(distribution, (List<Integer>)srcKeys))));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), List.of(in.replace((RelTrait)IgniteDistributions.single())));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelFieldCollation inFieldCollation;
        int newIndex;
        RelTraitSet in = inputTraits.get(0);
        List fieldCollations = TraitUtils.collation(nodeTraits).getFieldCollations();
        if (fieldCollations.isEmpty()) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)RelCollations.EMPTY)));
        }
        Int2IntOpenHashMap targets = new Int2IntOpenHashMap();
        for (Ord project : Ord.zip((List)this.getProjects())) {
            if (!(project.e instanceof RexInputRef)) continue;
            targets.putIfAbsent(project.i, ((RexSlot)project.e).getIndex());
        }
        ArrayList<RelFieldCollation> inFieldCollations = new ArrayList<RelFieldCollation>();
        Iterator iterator = fieldCollations.iterator();
        while (iterator.hasNext() && (newIndex = targets.getOrDefault((inFieldCollation = (RelFieldCollation)iterator.next()).getFieldIndex(), Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            inFieldCollations.add(inFieldCollation.withFieldIndex(newIndex));
        }
        if (inFieldCollations.size() == fieldCollations.size()) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)RelCollations.of(inFieldCollations))));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), List.of(in.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        IgniteDistribution distribution = TraitUtils.projectDistribution(TraitUtils.distribution(in), this.getProjects(), this.getInput().getRowType());
        boolean funcFound = this.exps.stream().anyMatch(IgniteProject::containsFunc);
        if (funcFound && distribution == IgniteDistributions.broadcast()) {
            distribution = IgniteDistributions.single();
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)distribution), List.of(in)));
    }

    private static boolean containsFunc(RexNode node) {
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitCall(RexCall call) {
                SqlOperator op = call.getOperator();
                if (op == IgniteSqlOperatorTable.RAND_UUID || op == GridgainSqlOperatorTable.NEXTVAL) {
                    throw Util.FoundOne.NULL;
                }
                return (Void)super.visitCall(call);
            }
        };
        try {
            node.accept((RexVisitor)v);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        RelCollation collation = TraitUtils.projectCollation(TraitUtils.collation(in), this.getProjects(), this.getInput().getRowType());
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)collation), List.of(in)));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this.getInput());
        RelOptCost cost = planner.getCostFactory().makeCost(rowCount, rowCount * 1.0, 0.0);
        if (this.distribution() == IgniteDistributions.single()) {
            cost = cost.plus(planner.getCostFactory().makeTinyCost());
        }
        return cost;
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteProject(cluster, this.getTraitSet(), (RelNode)IgniteProject.sole(inputs), this.getProjects(), this.getRowType());
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.addProjection((List<RexNode>)this.exps, this.getInput().getRowType());
    }

    public List<RexNode> expressions() {
        return this.exps;
    }
}

