/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessage;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class QueryCloseMessageImpl
implements QueryCloseMessage,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final int executionToken;
    @IgniteToStringInclude
    private final UUID queryId;

    private QueryCloseMessageImpl(int executionToken, UUID queryId) {
        this.executionToken = executionToken;
        this.queryId = queryId;
    }

    @Override
    public int executionToken() {
        return this.executionToken;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    public MessageSerializer serializer() {
        return QueryCloseMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryCloseMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryCloseMessageImpl otherMessage = (QueryCloseMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId) && this.executionToken == otherMessage.executionToken;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.executionToken, this.queryId);
        return result;
    }

    public QueryCloseMessageImpl clone() {
        try {
            return (QueryCloseMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static QueryCloseMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements QueryCloseMessageBuilder {
        private int executionToken;
        private UUID queryId;

        private Builder() {
        }

        @Override
        public QueryCloseMessageBuilder executionToken(int executionToken) {
            this.executionToken = executionToken;
            return this;
        }

        @Override
        public QueryCloseMessageBuilder queryId(UUID queryId) {
            Objects.requireNonNull(queryId, "queryId is not marked @Nullable");
            this.queryId = queryId;
            return this;
        }

        @Override
        public int executionToken() {
            return this.executionToken;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public QueryCloseMessage build() {
            return new QueryCloseMessageImpl(this.executionToken, Objects.requireNonNull(this.queryId, "queryId is not marked @Nullable"));
        }

        @Override
        public QueryCloseMessage buildDeserialized() {
            return new QueryCloseMessageImpl(this.executionToken, this.queryId);
        }
    }
}

