/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.sql.engine.message.CancelOperationRequest;
import org.apache.ignite.internal.sql.engine.message.CancelOperationRequestBuilder;
import org.apache.ignite.internal.sql.engine.message.CancelOperationRequestSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class CancelOperationRequestImpl
implements CancelOperationRequest,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 6;
    @IgniteToStringInclude
    private final String operationId;
    @IgniteToStringInclude
    private final int typeId;

    private CancelOperationRequestImpl(String operationId, int typeId) {
        this.operationId = operationId;
        this.typeId = typeId;
    }

    @Override
    public String operationId() {
        return this.operationId;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    public MessageSerializer serializer() {
        return CancelOperationRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(CancelOperationRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CancelOperationRequestImpl otherMessage = (CancelOperationRequestImpl)other;
        return Objects.equals(this.operationId, otherMessage.operationId) && this.typeId == otherMessage.typeId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.typeId, this.operationId);
        return result;
    }

    public CancelOperationRequestImpl clone() {
        try {
            return (CancelOperationRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CancelOperationRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements CancelOperationRequestBuilder {
        private String operationId;
        private int typeId;

        private Builder() {
        }

        @Override
        public CancelOperationRequestBuilder operationId(String operationId) {
            Objects.requireNonNull(operationId, "operationId is not marked @Nullable");
            this.operationId = operationId;
            return this;
        }

        @Override
        public CancelOperationRequestBuilder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        @Override
        public String operationId() {
            return this.operationId;
        }

        @Override
        public int typeId() {
            return this.typeId;
        }

        @Override
        public CancelOperationRequest build() {
            return new CancelOperationRequestImpl(Objects.requireNonNull(this.operationId, "operationId is not marked @Nullable"), this.typeId);
        }

        @Override
        public CancelOperationRequest buildDeserialized() {
            return new CancelOperationRequestImpl(this.operationId, this.typeId);
        }
    }
}

