/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.function.BiPredicate;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlJoinProjection;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractRightMaterializedJoinNode;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class NestedLoopJoinNode<RowT>
extends AbstractRightMaterializedJoinNode<RowT> {
    protected final BiPredicate<RowT, RowT> cond;
    final RowList<RowT> rightMaterialized;
    int processed = 0;

    NestedLoopJoinNode(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
        super(leftRowFactory, ctx);
        this.cond = cond;
        this.rightMaterialized = ctx.storageFactory().list(rightRowFactory, this.inBufSize);
    }

    @Override
    protected void rewindInternal() {
        this.rightMaterialized.clear();
        super.rewindInternal();
    }

    @Override
    protected void pushRight(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        --this.waitingRight;
        this.rightMaterialized.add(row);
        if (this.waitingRight == 0) {
            this.waitingRight = this.inBufSize;
            this.rightSource().request(this.waitingRight);
        }
    }

    @Override
    protected void closeInternal() {
        super.closeInternal();
        IgniteUtils.closeQuiet(() -> this.rightMaterialized.close());
    }

    public static <RowT> NestedLoopJoinNode<RowT> create(ExecutionContext<RowT> ctx, @Nullable SqlJoinProjection<RowT> joinProjection, RelDataType leftRowType, RelDataType rightRowType, JoinRelType joinType, BiPredicate<RowT, RowT> cond) {
        RowSchema leftRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)leftRowType));
        RowSchema rightRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rightRowType));
        RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(leftRowSchema);
        RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(rightRowSchema);
        switch (joinType) {
            case INNER: {
                assert (joinProjection != null);
                return new InnerJoin<RowT>(ctx, cond, joinProjection, leftRowFactory, rightRowFactory);
            }
            case LEFT: {
                assert (joinProjection != null);
                return new LeftJoin<RowT>(ctx, cond, joinProjection, leftRowFactory, rightRowFactory);
            }
            case RIGHT: {
                assert (joinProjection != null);
                return new RightJoin<RowT>(ctx, cond, joinProjection, leftRowFactory, rightRowFactory);
            }
            case FULL: {
                assert (joinProjection != null);
                return new FullOuterJoin<RowT>(ctx, cond, joinProjection, leftRowFactory, rightRowFactory);
            }
            case SEMI: {
                assert (joinProjection == null);
                return new SemiJoin<RowT>(ctx, cond, leftRowFactory, rightRowFactory);
            }
            case ANTI: {
                assert (joinProjection == null);
                return new AntiJoin<RowT>(ctx, cond, leftRowFactory, rightRowFactory);
            }
        }
        throw new IllegalStateException("Join type \"" + joinType + "\" is not supported yet");
    }

    void getMoreOrEnd() throws Exception {
        if (this.waitingRight == 0) {
            this.waitingRight = this.inBufSize;
            this.rightSource().request(this.waitingRight);
        }
        if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
            this.waitingLeft = this.inBufSize;
            this.leftSource().request(this.waitingLeft);
        }
        if (this.requested > 0 && this.waitingLeft == -1 && this.left == null && this.leftInBuf.isEmpty() && this.endOfRight()) {
            this.requested = 0;
            this.rightMaterialized.clear();
            this.downstream().end();
        }
    }

    protected boolean endOfRight() {
        return this.waitingRight == -1;
    }

    protected boolean rescheduleJoin() {
        if (this.processed++ > this.inBufSize) {
            this.execute(this::join);
            this.processed = 0;
            return true;
        }
        return false;
    }

    private static class InnerJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final SqlJoinProjection<RowT> outputProjection;
        private int rightIdx;

        private InnerJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, SqlJoinProjection<RowT> outputProjection, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, leftRowFactory, rightRowFactory);
            this.outputProjection = outputProjection;
        }

        @Override
        protected void rewindInternal() {
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.rightMaterialized.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            if (this.rescheduleJoin()) {
                                return;
                            }
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            Object row = this.outputProjection.project(this.context(), this.left, this.rightMaterialized.get(this.rightIdx - 1));
                            this.acquireRow(row);
                            this.downstream().push(row);
                            this.releaseRow(row);
                        }
                        if (this.rightIdx == this.rightMaterialized.size()) {
                            this.releaseRow(this.left);
                            this.left = null;
                            this.rightIdx = 0;
                        }
                        if (!this.rightMaterialized.isEmpty() || !this.rescheduleJoin()) continue;
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class LeftJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private final SqlJoinProjection<RowT> outputProjection;
        private boolean matched;
        private int rightIdx;

        private LeftJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, SqlJoinProjection<RowT> outputProjection, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, leftRowFactory, rightRowFactory);
            this.outputProjection = outputProjection;
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.matched = false;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                            this.matched = false;
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            if (this.rescheduleJoin()) {
                                return;
                            }
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            this.matched = true;
                            Object row = this.outputProjection.project(this.context(), this.left, this.rightMaterialized.get(this.rightIdx - 1));
                            this.acquireRow(row);
                            this.downstream().push(row);
                            this.releaseRow(row);
                        }
                        if (this.rightIdx == this.rightMaterialized.size()) {
                            boolean wasPushed = false;
                            if (!this.matched && this.requested > 0) {
                                --this.requested;
                                wasPushed = true;
                                Object row = this.outputProjection.project(this.context(), this.left, this.rightRowFactory.create());
                                this.acquireRow(row);
                                this.downstream().push(row);
                                this.releaseRow(row);
                            }
                            if (this.matched || wasPushed) {
                                this.releaseRow(this.left);
                                this.left = null;
                                this.rightIdx = 0;
                            }
                        }
                        if (!this.rightMaterialized.isEmpty() || !this.rescheduleJoin()) continue;
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class RightJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final SqlJoinProjection<RowT> outputProjection;
        @Nullable
        private BitSet rightNotMatchedIndexes;
        @Nullable
        private PrimitiveIterator.OfInt rightNotMatchedIt;
        private int rightIdx;

        private RightJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, SqlJoinProjection<RowT> outputProjection, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, leftRowFactory, rightRowFactory);
            this.outputProjection = outputProjection;
            this.leftRowFactory = leftRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.rightNotMatchedIndexes = null;
            this.rightNotMatchedIt = null;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.rightMaterialized.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                if (this.rightNotMatchedIndexes == null) {
                    this.rightNotMatchedIndexes = new BitSet(this.rightMaterialized.size());
                    this.rightNotMatchedIndexes.set(0, this.rightMaterialized.size());
                }
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            Object right;
                            if (this.rescheduleJoin()) {
                                return;
                            }
                            if (!this.cond.test(this.left, right = this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            this.rightNotMatchedIndexes.clear(this.rightIdx - 1);
                            Object joined = this.outputProjection.project(this.context(), this.left, right);
                            this.acquireRow(joined);
                            this.downstream().push(joined);
                            this.releaseRow(joined);
                        }
                        if (this.rightIdx == this.rightMaterialized.size()) {
                            this.releaseRow(this.left);
                            this.left = null;
                            this.rightIdx = 0;
                        }
                        if (!this.rightMaterialized.isEmpty() || !this.rescheduleJoin()) continue;
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
                if (this.waitingLeft == -1 && this.requested > 0) {
                    if (this.rightNotMatchedIt == null) {
                        this.rightNotMatchedIt = this.rightNotMatchedIndexes.stream().iterator();
                    }
                    this.inLoop = true;
                    try {
                        while (this.requested > 0 && this.rightNotMatchedIt.hasNext()) {
                            if (this.rescheduleJoin()) {
                                return;
                            }
                            int rowIdx = this.rightNotMatchedIt.nextInt();
                            RowT row = this.outputProjection.project(this.context(), this.leftRowFactory.create(), this.rightMaterialized.get(rowIdx));
                            --this.requested;
                            this.acquireRow(row);
                            this.downstream().push(row);
                            this.releaseRow(row);
                        }
                    }
                    finally {
                        this.inLoop = false;
                    }
                }
            }
            this.getMoreOrEnd();
        }

        @Override
        protected boolean endOfRight() {
            return this.waitingRight == -1 && this.rightNotMatchedIt != null && !this.rightNotMatchedIt.hasNext();
        }
    }

    private static class FullOuterJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private final SqlJoinProjection<RowT> outputProjection;
        private boolean leftMatched;
        @Nullable
        private BitSet rightNotMatchedIndexes;
        @Nullable
        private PrimitiveIterator.OfInt rightNotMatchedIt;
        private int rightIdx;

        private FullOuterJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, SqlJoinProjection<RowT> outputProjection, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, leftRowFactory, rightRowFactory);
            this.outputProjection = outputProjection;
            this.leftRowFactory = leftRowFactory;
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.leftMatched = false;
            this.rightNotMatchedIndexes = null;
            this.rightNotMatchedIt = null;
            this.rightIdx = 0;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                Object row;
                if (this.rightNotMatchedIndexes == null) {
                    this.rightNotMatchedIndexes = new BitSet(this.rightMaterialized.size());
                    this.rightNotMatchedIndexes.set(0, this.rightMaterialized.size());
                }
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                            this.leftMatched = false;
                        }
                        while (this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                            Object right;
                            if (this.rescheduleJoin()) {
                                return;
                            }
                            if (!this.cond.test(this.left, right = this.rightMaterialized.get(this.rightIdx++))) continue;
                            --this.requested;
                            this.leftMatched = true;
                            this.rightNotMatchedIndexes.clear(this.rightIdx - 1);
                            Object joined = this.outputProjection.project(this.context(), this.left, right);
                            this.acquireRow(joined);
                            this.downstream().push(joined);
                            this.releaseRow(joined);
                        }
                        if (this.rightIdx == this.rightMaterialized.size()) {
                            boolean wasPushed = false;
                            if (!this.leftMatched && this.requested > 0) {
                                --this.requested;
                                wasPushed = true;
                                row = this.outputProjection.project(this.context(), this.left, this.rightRowFactory.create());
                                this.acquireRow(row);
                                this.downstream().push(row);
                                this.releaseRow(row);
                            }
                            if (this.leftMatched || wasPushed) {
                                this.releaseRow(this.left);
                                this.left = null;
                                this.rightIdx = 0;
                            }
                        }
                        if (!this.rightMaterialized.isEmpty() || !this.rescheduleJoin()) continue;
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
                if (this.waitingLeft == -1 && this.requested > 0) {
                    if (this.rightNotMatchedIt == null) {
                        this.rightNotMatchedIt = this.rightNotMatchedIndexes.stream().iterator();
                    }
                    this.inLoop = true;
                    try {
                        while (this.requested > 0 && this.rightNotMatchedIt.hasNext()) {
                            int rowIdx = this.rightNotMatchedIt.nextInt();
                            row = this.outputProjection.project(this.context(), this.leftRowFactory.create(), this.rightMaterialized.get(rowIdx));
                            --this.requested;
                            this.acquireRow(row);
                            this.downstream().push(row);
                            this.releaseRow(row);
                            if (!this.rescheduleJoin()) continue;
                            return;
                        }
                    }
                    finally {
                        this.inLoop = false;
                    }
                }
            }
            this.getMoreOrEnd();
        }

        @Override
        protected boolean endOfRight() {
            return this.waitingRight == -1 && this.rightNotMatchedIt != null && !this.rightNotMatchedIt.hasNext();
        }
    }

    private static class SemiJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private int rightIdx;

        private SemiJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, leftRowFactory, rightRowFactory);
        }

        @Override
        protected void rewindInternal() {
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.rightMaterialized.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                    if (this.left == null) {
                        this.left = this.leftInBuf.remove();
                        this.acquireRow(this.left);
                    }
                    boolean matched = false;
                    while (!matched && this.requested > 0 && this.rightIdx < this.rightMaterialized.size()) {
                        if (this.rescheduleJoin()) {
                            return;
                        }
                        if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                        --this.requested;
                        this.downstream().push(this.left);
                        matched = true;
                    }
                    if (matched || this.rightIdx == this.rightMaterialized.size()) {
                        this.releaseRow(this.left);
                        this.left = null;
                        this.rightIdx = 0;
                    }
                    if (!this.rightMaterialized.isEmpty() || !this.rescheduleJoin()) continue;
                    return;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class AntiJoin<RowT>
    extends NestedLoopJoinNode<RowT> {
        private int rightIdx;

        private AntiJoin(ExecutionContext<RowT> ctx, BiPredicate<RowT, RowT> cond, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory) {
            super(ctx, cond, leftRowFactory, rightRowFactory);
        }

        @Override
        protected void rewindInternal() {
            this.rightIdx = 0;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (this.left == null) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                        }
                        boolean matched = false;
                        while (this.rightIdx < this.rightMaterialized.size()) {
                            if (this.rescheduleJoin()) {
                                return;
                            }
                            if (!this.cond.test(this.left, this.rightMaterialized.get(this.rightIdx++))) continue;
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            --this.requested;
                            this.downstream().push(this.left);
                        }
                        this.releaseRow(this.left);
                        this.left = null;
                        this.rightIdx = 0;
                        if (!this.rightMaterialized.isEmpty() || !this.rescheduleJoin()) continue;
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }
}

