/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.offload;

import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.NoOpMemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.offload.OffloadAwareCollection;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class OffloadAwareSortedQueueAdapter<RowT>
implements RowQueue<RowT>,
OffloadAwareCollection {
    private RowQueue<RowT> delegate;
    private final Supplier<RowQueue<RowT>> queueSupplier;
    private final Runnable spillingAction;
    private MemoryContext<RowT> memoryContext;
    private boolean wasSpilled;
    private boolean wasClosed;

    OffloadAwareSortedQueueAdapter(MemoryContext<RowT> memoryContext, RowQueue<RowT> delegate, Runnable spillingAction, Supplier<RowQueue<RowT>> queueSupplier) {
        this.memoryContext = memoryContext;
        this.delegate = delegate;
        this.spillingAction = spillingAction;
        this.queueSupplier = queueSupplier;
    }

    @Override
    public void add(RowT element) {
        this.checkClosed();
        this.acquire(element);
        RowT row = this.delegate.enqueue(element);
        if (row != null) {
            this.release(row);
        }
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.release(this.delegate);
        this.delegate.clear();
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.delegate.isEmpty();
    }

    @Override
    @Nullable
    public RowT peek() {
        this.checkClosed();
        return this.delegate.peek();
    }

    @Override
    @Nullable
    public RowT poll() {
        this.checkClosed();
        RowT row = this.delegate.poll();
        if (row != null) {
            this.release(row);
        }
        return row;
    }

    @Override
    public RowT remove() {
        this.checkClosed();
        return this.delegate.remove();
    }

    @Override
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return this.delegate.iterator();
    }

    @Override
    public void onSpillToDisk() {
        if (this.wasSpilled || this.wasClosed) {
            return;
        }
        this.wasSpilled = true;
        RowQueue<RowT> inMemoryCollection = this.delegate;
        this.delegate = this.queueSupplier.get();
        for (Object row : inMemoryCollection) {
            this.delegate.add(row);
            this.release(row);
        }
        IgniteUtils.closeQuiet(() -> inMemoryCollection.close());
        this.memoryContext = NoOpMemoryContext.instance();
    }

    public void close() throws Exception {
        if (this.wasClosed) {
            return;
        }
        this.wasClosed = true;
        this.release(this.delegate);
        this.delegate.close();
    }

    private void acquire(RowT element) {
        if (!this.memoryContext.tryAcquire(element)) {
            this.spillingAction.run();
        }
    }

    private void checkClosed() {
        if (this.wasClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Sorted row store has been closed.");
        }
    }

    private void release(RowT row) {
        this.memoryContext.release(row);
    }

    private void release(Iterable<RowT> rows) {
        if (this.wasSpilled) {
            return;
        }
        rows.forEach(this::release);
    }
}

