/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.offload;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.NoOpMemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashTable;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.offload.OffloadAwareCollection;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class OffloadAwareHashTable<RowT, K, V>
implements RowHashTable<K, V>,
OffloadAwareCollection {
    private final Supplier<RowHashTable<K, V>> fileCollectionSupplier;
    private final Runnable spillingAction;
    private RowHashTable<K, V> delegate;
    private MemoryContext<RowT> memoryContext;
    private boolean wasSpilled;
    private boolean wasClosed;

    public OffloadAwareHashTable(RowHashTable<K, V> delegate, Supplier<RowHashTable<K, V>> fileCollectionSupplier, MemoryContext<RowT> memoryContext, Runnable spillingAction) {
        this.delegate = delegate;
        this.fileCollectionSupplier = Objects.requireNonNull(fileCollectionSupplier, "fileCollectionSupplier");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext");
        this.spillingAction = Objects.requireNonNull(spillingAction, "spillingAction");
    }

    @Override
    public V put(K key, V value) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.acquireEntry(key, value);
        if (!this.wasSpilled) {
            V oldValue = this.delegate.put(key, value);
            if (oldValue != null) {
                this.memoryContext.releaseEntry(key, oldValue);
            }
            return null;
        }
        this.delegate.put(key, value);
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> mappingFunction) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        if (!this.wasSpilled) {
            V val = this.delegate.get(key);
            if (val == null) {
                val = mappingFunction.apply(key);
                Objects.requireNonNull(val, "New value can not be null");
                this.acquireEntry(key, val);
                this.delegate.put(key, val);
            }
            return val;
        }
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    @Nullable
    public V remove(K key) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        V value = this.delegate.remove(key);
        if (value != null) {
            this.releaseEntry(key, value);
        }
        return value;
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.release(this.delegate);
        this.delegate.clear();
    }

    @Override
    @Nullable
    public V get(K key) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        return this.delegate.get(key);
    }

    @Override
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        this.checkClosed();
        return new OffloadAwareIterator(this.delegate.entryIterator());
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    public void close() throws Exception {
        if (this.wasClosed) {
            return;
        }
        this.wasClosed = true;
        this.release(this.delegate);
        this.delegate.close();
    }

    private void acquireEntry(K key, V value) {
        if (!this.memoryContext.tryAcquireEntry(key, value)) {
            this.spillingAction.run();
        }
    }

    private void release(RowHashTable<K, V> delegate) {
        if (this.wasSpilled) {
            return;
        }
        Iterator<Map.Entry<K, V>> it = delegate.entryIterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            this.releaseEntry(entry.getKey(), entry.getValue());
        }
        delegate.clear();
    }

    private void releaseEntry(K key, V value) {
        if (this.wasSpilled) {
            return;
        }
        this.memoryContext.releaseEntry(key, value);
    }

    private void checkClosed() {
        if (this.wasClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSpillToDisk() {
        if (this.wasSpilled || this.wasClosed) {
            return;
        }
        this.wasSpilled = true;
        RowHashTable<K, V> inMemoryCollection = this.delegate;
        this.delegate = this.fileCollectionSupplier.get();
        try {
            Iterator<Map.Entry<K, V>> it = inMemoryCollection.entryIterator();
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                this.delegate.put(entry.getKey(), entry.getValue());
                this.memoryContext.releaseEntry(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.memoryContext = NoOpMemoryContext.instance();
            IgniteUtils.closeQuiet(() -> inMemoryCollection.close());
        }
    }

    private class OffloadAwareIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Map.Entry<K, V> current;
        private final boolean initialState;

        private OffloadAwareIterator(Iterator<Map.Entry<K, V>> it) {
            this.initialState = OffloadAwareHashTable.this.wasSpilled;
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            this.checkState();
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.checkState();
            this.current = this.it.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.checkState();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            OffloadAwareHashTable.this.releaseEntry(this.current.getKey(), this.current.getValue());
            this.it.remove();
            this.current = null;
        }

        private void checkState() {
            if (this.initialState != OffloadAwareHashTable.this.wasSpilled) {
                throw new IllegalStateException("Iterator is no longer valid");
            }
            OffloadAwareHashTable.this.checkClosed();
        }
    }
}

