/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;

@NotThreadSafe
class RowSetImpl<E>
implements RowSet<E> {
    private final MemoryContext<?> memoryContext;
    private HashSet<E> delegate;

    RowSetImpl(MemoryContext<?> memoryContext) {
        this.memoryContext = memoryContext;
        this.delegate = new HashSet();
    }

    @Override
    public boolean add(E element) {
        this.checkClosed();
        Objects.requireNonNull(element, "element");
        this.memoryContext.acquireObject(element);
        boolean added = this.delegate.add(element);
        if (!added) {
            this.memoryContext.releaseObject(element);
        }
        return added;
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.checkClosed();
        for (E element : this.delegate) {
            this.memoryContext.releaseObject(element);
        }
        this.delegate.clear();
    }

    @Override
    public Iterator<E> iterator() {
        this.checkClosed();
        return this.delegate.iterator();
    }

    @Override
    public void close() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.clear();
        this.delegate = null;
    }

    private void checkClosed() {
        if (this.delegate == null) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
        }
    }
}

