/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowSet;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalHashTable;

@NotThreadSafe
class RowSetImpl<E>
implements RowSet<E> {
    private static final int INITIAL_CAPACITY = 128;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final ExternalHashTable hashTable;
    private final KeyValueCodec<E, Void> codec;

    RowSetImpl(DataDirectory workDir, FileIoFactory fileIoFactory, KeyValueCodec<E, Void> codec) {
        this.codec = codec;
        this.hashTable = new ExternalHashTable(workDir, fileIoFactory, 128);
    }

    @Override
    public boolean add(E element) {
        BinaryTuple key = this.codec.encodeKey(element);
        if (this.hashTable.get(key) != null) {
            return false;
        }
        this.hashTable.put(key, EMPTY_BUFFER);
        return true;
    }

    @Override
    public int size() {
        return this.hashTable.size();
    }

    @Override
    public void clear() {
        this.hashTable.reset();
    }

    @Override
    public void close() {
        this.hashTable.close();
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<Map.Entry<BinaryTuple, ByteBuffer>> it = this.hashTable.entryIterator();
        return new KeysIterator(it);
    }

    private class KeysIterator
    implements Iterator<E> {
        final Iterator<Map.Entry<BinaryTuple, ByteBuffer>> it;

        private KeysIterator(Iterator<Map.Entry<BinaryTuple, ByteBuffer>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            Map.Entry<BinaryTuple, ByteBuffer> entry = this.it.next();
            return RowSetImpl.this.codec.decodeKey(entry.getKey());
        }
    }
}

