/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp.agg;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AccumulatorsState {
    private final Object[] row;
    private final BitSet set = new BitSet();
    private int index;

    public AccumulatorsState(int rowSize) {
        this.row = new Object[rowSize];
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void resetIndex() {
        this.index = -1;
    }

    @Nullable
    public Object get() {
        return this.row[this.index];
    }

    public void set(@Nullable Object value) {
        this.row[this.index] = value;
        this.set.set(this.index);
    }

    public boolean hasValue() {
        return this.set.get(this.index);
    }

    public int size() {
        return this.row.length;
    }

    @TestOnly
    public List<Object> toList() {
        return Arrays.asList(this.row);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

