/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Supplier;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;

public class ResolvedDependencies {
    private final Int2ObjectMap<ExecutableTable> tableMap;
    private final Int2ObjectMap<ScannableDataSource> dataSourceMap;

    public ResolvedDependencies(Int2ObjectMap<ExecutableTable> tableMap, Int2ObjectMap<ScannableDataSource> dataSourceMap) {
        this.tableMap = tableMap;
        this.dataSourceMap = dataSourceMap;
    }

    public ScannableTable scannableTable(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.scannableTable();
    }

    public ScannableTable scannableSecondaryStorageTable(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.secondaryStorageTable();
    }

    public UpdatableTable updatableTable(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.updatableTable();
    }

    public TableDescriptor tableDescriptor(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.tableDescriptor();
    }

    public Supplier<PartitionCalculator> partitionCalculator(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.partitionCalculator();
    }

    public ScannableDataSource dataSource(int dataSourceId) {
        ScannableDataSource dataSource = (ScannableDataSource)this.dataSourceMap.get(dataSourceId);
        assert (dataSource != null) : "DataSource does not exist: " + dataSourceId;
        return dataSource;
    }

    private ExecutableTable getTable(int tableId) {
        ExecutableTable executableTable = (ExecutableTable)this.tableMap.get(tableId);
        assert (executableTable != null) : "ExecutableTable does not exist: " + tableId;
        return executableTable;
    }
}

