/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteAbstractSqlAlterTable;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlAlterTableSetProperties
extends IgniteAbstractSqlAlterTable {
    private final SqlNodeList propertyList;

    public IgniteSqlAlterTableSetProperties(SqlParserPos pos, boolean ifExists, SqlIdentifier tblName, SqlNodeList propertyList) {
        super(new Operator(ifExists), pos, tblName);
        this.propertyList = Objects.requireNonNull(propertyList, "property list");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.propertyList);
    }

    @Override
    protected void unparseAlterTableOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SET");
        SqlWriter.Frame frame = writer.startList("(", ")");
        this.propertyList.unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    public SqlNodeList propertyList() {
        return this.propertyList;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("ALTER TABLE", SqlKind.ALTER_TABLE, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlAlterTableSetProperties(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlNodeList)operands[1]);
        }
    }
}

