/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.externalize;

import java.util.List;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.checkerframework.checker.nullness.qual.Nullable;

class RelOptSchemaImpl
implements RelOptSchema {
    private final SchemaPlus root;

    RelOptSchemaImpl(SchemaPlus root) {
        this.root = root;
    }

    public RelOptTable getTableForMember(List<String> names) {
        if (CollectionUtils.nullOrEmpty(names) || names.size() != 2) {
            throw new SqlException(ErrorGroups.Common.INTERNAL_ERR, "Expected name of exactly two parts, but was " + names);
        }
        SchemaPlus schema = this.root.getSubSchema(names.get(0));
        if (schema == null) {
            throw new SqlException(ErrorGroups.Common.INTERNAL_ERR, "Schema with name \"" + names.get(0) + "\" not found");
        }
        Table table = schema.getTable(names.get(1));
        if (table == null) {
            throw new SqlException(ErrorGroups.Common.INTERNAL_ERR, "Table with name " + names + " not found");
        }
        return new RelOptTableImpl(names, (IgniteDataSource)table);
    }

    public RelDataTypeFactory getTypeFactory() {
        return Commons.typeFactory();
    }

    public void registerRules(RelOptPlanner planner) {
        throw new AssertionError((Object)"Should not be called");
    }

    private static class RelOptTableImpl
    implements RelOptTable {
        private final List<String> qualifiedName;
        private final IgniteDataSource igniteDataSource;

        private RelOptTableImpl(List<String> qualifiedName, IgniteDataSource igniteDataSource) {
            this.qualifiedName = qualifiedName;
            this.igniteDataSource = igniteDataSource;
        }

        public List<String> getQualifiedName() {
            return this.qualifiedName;
        }

        public double getRowCount() {
            throw new AssertionError((Object)"Should not be called");
        }

        public RelDataType getRowType() {
            throw new AssertionError((Object)"Should not be called");
        }

        public @Nullable RelOptSchema getRelOptSchema() {
            return null;
        }

        public RelNode toRel(RelOptTable.ToRelContext context) {
            throw new AssertionError((Object)"Should not be called");
        }

        public @Nullable List<RelCollation> getCollationList() {
            throw new AssertionError((Object)"Should not be called");
        }

        public @Nullable RelDistribution getDistribution() {
            throw new AssertionError((Object)"Should not be called");
        }

        public boolean isKey(ImmutableBitSet columns) {
            throw new AssertionError((Object)"Should not be called");
        }

        public @Nullable List<ImmutableBitSet> getKeys() {
            throw new AssertionError((Object)"Should not be called");
        }

        public @Nullable List<RelReferentialConstraint> getReferentialConstraints() {
            throw new AssertionError((Object)"Should not be called");
        }

        public @Nullable Expression getExpression(Class clazz) {
            throw new AssertionError((Object)"Should not be called");
        }

        public RelOptTable extend(List<RelDataTypeField> extendedFields) {
            throw new AssertionError((Object)"Should not be called");
        }

        public List<ColumnStrategy> getColumnStrategies() {
            throw new AssertionError((Object)"Should not be called");
        }

        public <C> @Nullable C unwrap(Class<C> clazz) {
            if (clazz.isAssignableFrom(this.igniteDataSource.getClass())) {
                return clazz.cast(this.igniteDataSource);
            }
            return null;
        }
    }
}

