/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;

public class SortNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private int requested;
    private int waiting;
    private boolean inLoop;
    private final RowQueue<RowT> rows;
    private final long fetch;
    private final long offset;
    private RowList<RowT> reversed;
    private final RowHandler.RowFactory<RowT> rowFactory;

    public SortNode(ExecutionContext<RowT> ctx, RowHandler.RowFactory<RowT> rowFactory, Comparator<RowT> comp, Comparator<ByteBuffer> tupleComp, long offset, long fetch) {
        super(ctx);
        long limit;
        assert (fetch == -1L || fetch >= 0L);
        assert (offset >= 0L);
        if (offset > 0L && fetch == -1L) {
            throw new AssertionError((Object)"Offset-only case is not supported by Sort node");
        }
        this.fetch = fetch;
        this.offset = offset;
        this.rowFactory = rowFactory;
        long l = limit = fetch == -1L ? -1L : IgniteMath.addExact(fetch, offset);
        if (limit < 1L || limit > Integer.MAX_VALUE) {
            this.rows = ctx.storageFactory().priorityQueue(rowFactory, comp, tupleComp);
        } else {
            comp = comp == null ? Comparator.reverseOrder() : comp.reversed();
            this.rows = ctx.storageFactory().boundedPriorityQueue(rowFactory, (int)limit, comp, tupleComp == null ? null : tupleComp.reversed());
        }
    }

    public SortNode(ExecutionContext<RowT> ctx, Comparator<RowT> comp) {
        this(ctx, null, comp, null, 0L, -1L);
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.rows.clear();
        if (this.reversed != null) {
            this.reversed.clear();
        }
    }

    @Override
    protected void closeInternal() {
        super.closeInternal();
        IgniteUtils.closeQuiet(() -> this.rows.close());
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        assert (this.waiting <= 0);
        if (this.fetch == 0L) {
            this.downstream().end();
            return;
        }
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        } else if (!this.inLoop) {
            this.execute(this::flush);
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        assert (this.reversed == null || this.reversed.isEmpty());
        --this.waiting;
        this.rows.add(row);
        if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.waiting = -1;
        this.flush();
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waiting=").app(this.waiting).app(", fetch=").app(this.fetch).app(", offset=").app(this.offset);
    }

    private void flush() throws Exception {
        assert (this.waiting == -1);
        int processed = 0;
        this.inLoop = true;
        try {
            if (this.fetch > 0L && !this.rows.isEmpty()) {
                if (this.reversed == null) {
                    this.reversed = this.context().storageFactory().list(this.rowFactory, this.rows.size());
                }
                while ((long)this.rows.size() > this.offset) {
                    this.reversed.add(this.rows.poll());
                    if (++processed < this.inBufSize) continue;
                    this.execute(this::flush);
                    return;
                }
                this.rows.clear();
                processed = 0;
            }
            while (this.requested > 0 && !(this.reversed != null ? this.reversed.isEmpty() : this.rows.isEmpty())) {
                --this.requested;
                RowT row = this.reversed == null ? this.rows.poll() : this.reversed.removeLast();
                this.acquireRow(row);
                this.downstream().push(row);
                this.releaseRow(row);
                if (++processed < this.inBufSize || this.requested <= 0) continue;
                this.execute(this::flush);
                return;
            }
            if (this.reversed == null ? this.rows.isEmpty() : this.reversed.isEmpty()) {
                if (this.requested > 0) {
                    this.downstream().end();
                }
                this.requested = 0;
            }
        }
        finally {
            this.inLoop = false;
        }
    }
}

