/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.SortedExternalRowStore;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class BoundedSortedExternalRowStore
extends SortedExternalRowStore {
    private final int capacity;
    private int processed;
    private boolean needToShift = true;

    public BoundedSortedExternalRowStore(Comparator<ByteBuffer> tupleComp, FileIoFactory fileIoFactory, DataDirectory workDir, int columnCount, int capacity) {
        super(tupleComp, fileIoFactory, workDir, columnCount);
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive: " + capacity);
        }
        this.capacity = capacity;
    }

    private void shiftIfNeeded() {
        if (this.needToShift && super.size() > this.capacity) {
            int itemsToSkip = super.size() - this.capacity;
            for (int i = 0; i < itemsToSkip; ++i) {
                super.poll();
            }
            this.needToShift = false;
        }
    }

    @Override
    public int size() {
        if (this.processed == this.capacity) {
            return 0;
        }
        return super.size() > this.capacity ? this.capacity : super.size();
    }

    @Override
    @Nullable
    public BinaryTuple poll() {
        this.shiftIfNeeded();
        if (this.processed + 1 > this.capacity) {
            return null;
        }
        BinaryTuple tup = super.poll();
        if (tup != null) {
            ++this.processed;
        }
        return tup;
    }

    @Override
    @Nullable
    public BinaryTuple peek() {
        this.shiftIfNeeded();
        if (this.processed + 1 > this.capacity) {
            return null;
        }
        return super.peek();
    }

    @Override
    public Iterator<BinaryTuple> iterator() {
        this.shiftIfNeeded();
        final Iterator<BinaryTuple> it = super.iterator();
        return new Iterator<BinaryTuple>(){
            int innerProcessed;

            @Override
            public boolean hasNext() {
                if (this.innerProcessed + 1 > BoundedSortedExternalRowStore.this.capacity || BoundedSortedExternalRowStore.this.processed + 1 > BoundedSortedExternalRowStore.this.capacity) {
                    return false;
                }
                return it.hasNext();
            }

            @Override
            public BinaryTuple next() {
                if (this.innerProcessed + 1 > BoundedSortedExternalRowStore.this.capacity || BoundedSortedExternalRowStore.this.processed + 1 > BoundedSortedExternalRowStore.this.capacity) {
                    throw new NoSuchElementException();
                }
                ++this.innerProcessed;
                return (BinaryTuple)it.next();
            }
        };
    }

    @Override
    public void clear() {
        this.processed = 0;
        this.needToShift = true;
        super.clear();
    }
}

