/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteAbstractSqlAlterTable;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlAlterTableAddSecondaryZone
extends IgniteAbstractSqlAlterTable {
    private final SqlIdentifier secondaryZoneName;
    private final @Nullable SqlNode secondaryProfileName;

    public IgniteSqlAlterTableAddSecondaryZone(SqlParserPos pos, boolean ifExists, SqlIdentifier tableName, SqlIdentifier secondaryZoneName, @Nullable SqlNode secondaryProfileName) {
        super(new Operator(ifExists), pos, tableName);
        this.secondaryZoneName = secondaryZoneName;
        this.secondaryProfileName = secondaryProfileName;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.secondaryZoneName, (Object)this.secondaryProfileName);
    }

    @Override
    protected void unparseAlterTableOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ADD");
        writer.keyword("SECONDARY ZONE");
        this.secondaryZoneName.unparse(writer, leftPrec, rightPrec);
        if (this.secondaryProfileName != null) {
            writer.keyword("STORAGE PROFILE");
            this.secondaryProfileName.unparse(writer, leftPrec, rightPrec);
        }
    }

    public SqlIdentifier secondaryZoneName() {
        return this.secondaryZoneName;
    }

    public SqlNode secondaryProfileName() {
        return this.secondaryProfileName;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("ALTER TABLE", SqlKind.ALTER_TABLE, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlAlterTableAddSecondaryZone(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlIdentifier)operands[1], operands[2]);
        }
    }
}

