/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashTable;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class RowHashTableImpl<RowT, K, V>
implements RowHashTable<K, V> {
    private final MemoryContext<RowT> memoryContext;
    @Nullable
    private Map<K, V> delegate = new HashMap();

    public RowHashTableImpl(MemoryContext<RowT> memoryContext) {
        this.memoryContext = memoryContext;
    }

    @Override
    public V put(K key, V value) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.memoryContext.acquireEntry(key, value);
        V oldValue = this.delegate.put(key, value);
        if (oldValue != null) {
            this.memoryContext.releaseEntry(key, oldValue);
        }
        return oldValue;
    }

    @Override
    @Nullable
    public V get(K key) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        return this.delegate.get(key);
    }

    @Override
    @Nullable
    public V remove(K key) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        V oldValue = this.delegate.remove(key);
        if (oldValue != null) {
            this.memoryContext.releaseEntry(key, oldValue);
        }
        return oldValue;
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> mappingFunction) {
        this.checkClosed();
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        V val = this.delegate.get(key);
        if (val == null) {
            val = mappingFunction.apply(key);
            Objects.requireNonNull(val, "New value cannot be null");
            this.memoryContext.acquireEntry(key, val);
            this.delegate.put(key, val);
        }
        return val;
    }

    @Override
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        this.checkClosed();
        return new InMemoryIterator(this.delegate.entrySet().iterator());
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.delegate.clear();
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.delegate.isEmpty();
    }

    public void close() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.entrySet().stream().forEach(e -> this.memoryContext.releaseEntry(e.getKey(), e.getValue()));
        this.delegate = null;
    }

    private void checkClosed() {
        if (this.delegate == null) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
        }
    }

    private class InMemoryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Map.Entry<K, V> current;

        private InMemoryIterator(Iterator<Map.Entry<K, V>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.it.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            RowHashTableImpl.this.memoryContext.releaseEntry(this.current.getKey(), this.current.getValue());
            this.it.remove();
            this.current = null;
        }
    }
}

