/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory;

import java.util.Comparator;
import org.apache.ignite.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.inmemory.RowQueueImpl;
import org.apache.ignite.internal.util.BoundedPriorityQueue;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

class BoundedSortedRowQueueImpl<RowT>
extends RowQueueImpl<RowT> {
    BoundedSortedRowQueueImpl(MemoryContext<RowT> memoryContext, int capacity, Comparator<RowT> comparator) {
        super(memoryContext, new BoundedPriorityQueue(capacity, comparator));
        assert (capacity > 0);
    }

    @Override
    public void add(RowT element) {
        this.enqueue(element);
    }

    @Override
    @Nullable
    public RowT enqueue(RowT element) {
        this.checkClosed();
        Object row = ((BoundedPriorityQueue)this.delegate).enqueue(element);
        if (row == element) {
            return element;
        }
        this.memoryContext.acquire(element);
        if (row != null) {
            this.memoryContext.release(row);
        }
        return (RowT)row;
    }

    @Override
    protected void checkClosed() {
        if (this.delegate == null) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Sorted row store has been closed.");
        }
    }
}

