/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowHashTable;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalHashTable;
import org.apache.ignite.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class RowHashTableImpl<RowT, K, V>
implements RowHashTable<K, V> {
    private static final int INITIAL_CAPACITY = 128;
    private final ExternalHashTable hashTable;
    private final KeyValueCodec<K, V> keyValueCodec;
    private ByteBuffer localBuffer;
    private boolean isClosed;

    public RowHashTableImpl(DataDirectory workDir, FileIoFactory fileIoFactory, KeyValueCodec<K, V> keyValueCodec) {
        this.hashTable = new ExternalHashTable(workDir, fileIoFactory, 128);
        this.keyValueCodec = keyValueCodec;
        this.localBuffer = RowHashTableImpl.allocateNewBuffer(keyValueCodec.initialValueSizeInBytes());
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        BinaryTuple tupleKey = this.keyValueCodec.encodeKey(key);
        ByteBuffer buffer = this.encodeHashTableValue(value);
        this.hashTable.put(tupleKey, buffer);
        return null;
    }

    @Override
    @Nullable
    public V computeIfAbsent(K key, Function<K, V> mappingFunction) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        BinaryTuple tupleKey = this.keyValueCodec.encodeKey(key);
        Object[] newValHolder = new Object[]{null};
        ByteBuffer valueBuf = this.hashTable.computeIfAbsent(tupleKey, (BinaryTuple k) -> {
            Object newVal = mappingFunction.apply(key);
            if (newVal == null) {
                throw new NullPointerException("New value can not be null");
            }
            newValHolder[0] = newVal;
            return this.encodeHashTableValue(newVal);
        });
        Object val = newValHolder[0] != null ? newValHolder[0] : this.keyValueCodec.decodeValue(valueBuf);
        return (V)val;
    }

    @Override
    @Nullable
    public V remove(K key) {
        Objects.requireNonNull(key, "key");
        BinaryTuple tupleKey = this.keyValueCodec.encodeKey(key);
        ByteBuffer valBuf = this.hashTable.remove(tupleKey);
        if (valBuf == null) {
            return null;
        }
        return this.keyValueCodec.decodeValue(valBuf);
    }

    @Override
    public void clear() {
        this.hashTable.reset();
    }

    @Override
    @Nullable
    public V get(K key) {
        Objects.requireNonNull(key, "key");
        BinaryTuple tupleKey = this.keyValueCodec.encodeKey(key);
        ByteBuffer val = this.hashTable.get(tupleKey);
        if (val == null) {
            return null;
        }
        return this.keyValueCodec.decodeValue(val);
    }

    @Override
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        final Iterator<Map.Entry<BinaryTuple, ByteBuffer>> it = this.hashTable.entryIterator();
        return new Iterator<Map.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry entry = (Map.Entry)it.next();
                Object key = RowHashTableImpl.this.keyValueCodec.decodeKey((BinaryTuple)entry.getKey());
                Object val = RowHashTableImpl.this.keyValueCodec.decodeValue((ByteBuffer)entry.getValue());
                return new ExternalEntry(key, val);
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.hashTable.size();
    }

    public void close() throws Exception {
        this.isClosed = true;
        this.hashTable.close();
    }

    private ByteBuffer encodeHashTableValue(V val) {
        this.localBuffer.clear();
        ByteBuffer newBuffer = this.keyValueCodec.encodeValue(val, this.localBuffer);
        if (newBuffer != null) {
            this.localBuffer = newBuffer;
        }
        this.localBuffer.flip();
        return this.localBuffer;
    }

    private static ByteBuffer allocateNewBuffer(int capacity) {
        return ByteBuffer.allocate(capacity).order(BinaryTupleParser.ORDER);
    }

    private class ExternalEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        private ExternalEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            this.checkClosed();
            return this.key;
        }

        @Override
        public V getValue() {
            this.checkClosed();
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        private void checkClosed() {
            if (RowHashTableImpl.this.isClosed) {
                throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
            }
        }
    }
}

