/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util.format;

import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.util.format.DateTimeTemplateField;

final class ParsedFields {
    private final Map<DateTimeTemplateField.FieldKind, Object> values = new EnumMap<DateTimeTemplateField.FieldKind, Object>(DateTimeTemplateField.FieldKind.class);
    private IntPair hours12Value;
    private IntPair tzValue;
    private IntPair yearValue;
    private Integer roundedYearValue;

    ParsedFields() {
    }

    void addYear(int base, int value) {
        this.yearValue = IntPair.of((int)base, (int)value);
    }

    void addRoundedYear(int years) {
        this.roundedYearValue = years;
    }

    void add(DateTimeTemplateField.FieldKind field, Object value) {
        Objects.requireNonNull(field, "field");
        Objects.requireNonNull(value, "value");
        assert (field != DateTimeTemplateField.FieldKind.HOUR_12) : "use add hours12";
        assert (field != DateTimeTemplateField.FieldKind.TIMEZONE) : "use add tz";
        Object prev = this.values.put(field, value);
        if (prev != null) {
            throw new IllegalStateException("Field appeared more than once " + field);
        }
    }

    void addHours12(boolean pm, int hours) {
        this.hours12Value = IntPair.of((int)(pm ? 1 : 0), (int)hours);
    }

    void addTz(int hours, int minutes) {
        this.tzValue = IntPair.of((int)hours, (int)minutes);
    }

    LocalTime getTime() {
        if (this.values.containsKey((Object)DateTimeTemplateField.FieldKind.SECOND_OF_DAY)) {
            long seconds = this.fieldValue(DateTimeTemplateField.FieldKind.SECOND_OF_DAY, 0);
            long nanos = this.fieldValue(DateTimeTemplateField.FieldKind.FRACTION, 0);
            if (nanos == 0L) {
                return LocalTime.ofSecondOfDay(seconds);
            }
            long ns = TimeUnit.SECONDS.toNanos(1L);
            long value = (seconds * ns + nanos) / ns;
            return LocalTime.ofSecondOfDay(value);
        }
        int hours = this.hours12Value != null ? this.convertToHours24(this.hours12Value) : this.fieldValue(DateTimeTemplateField.FieldKind.HOUR_24, 0);
        int minutes = this.fieldValue(DateTimeTemplateField.FieldKind.MINUTE, 0);
        int seconds = this.fieldValue(DateTimeTemplateField.FieldKind.SECOND_OF_MINUTE, 0);
        int nanos = this.fieldValue(DateTimeTemplateField.FieldKind.FRACTION, 0);
        return LocalTime.of(hours, minutes, seconds, nanos);
    }

    LocalDate getDate(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        LocalDate now = LocalDate.now(clock);
        int year = this.roundedYearValue != null ? this.convertRoundedYear(clock, this.roundedYearValue) : (this.yearValue != null ? this.convertYear(this.yearValue) : Year.now(clock).getValue());
        if (this.values.containsKey((Object)DateTimeTemplateField.FieldKind.DAY_OF_YEAR)) {
            int day = this.fieldValue(DateTimeTemplateField.FieldKind.DAY_OF_YEAR, 0);
            return LocalDate.ofYearDay(year, day);
        }
        int month = this.fieldValue(DateTimeTemplateField.FieldKind.MONTH, now.getMonthValue());
        int day = this.fieldValue(DateTimeTemplateField.FieldKind.DAY_OF_MONTH, now.getDayOfMonth());
        return LocalDate.of(year, month, day);
    }

    LocalDateTime getDateTime(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        LocalTime time = this.getTime();
        LocalDate date = this.getDate(clock);
        return LocalDateTime.of(date, time);
    }

    @Nullable
    ZoneOffset toZoneOffset() {
        if (this.tzValue == null) {
            return null;
        }
        int hours = this.tzValue.source;
        int minutes = this.tzValue.target;
        ParsedFields.validateRange(Math.abs(minutes), 0, 59, DateTimeTemplateField.TZM.displayName());
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    private int fieldValue(DateTimeTemplateField.FieldKind kind, int defaultValue) {
        return (Integer)this.values.getOrDefault((Object)kind, defaultValue);
    }

    private int convertRoundedYear(Clock clock, int v) {
        int now = Year.now(clock).getValue();
        int year2digits = now % 100;
        int base = now - year2digits;
        if (v <= 49) {
            return year2digits <= 49 ? base + v : base + 100 + v;
        }
        if (v < 100) {
            return year2digits <= 49 ? base - 100 + v : base + v;
        }
        return v;
    }

    private int convertYear(IntPair baseAndYears) {
        int value = baseAndYears.source + baseAndYears.target;
        ParsedFields.validateRange(value, 1, 9999, DateTimeTemplateField.YYYY.displayName());
        return value;
    }

    private int convertToHours24(IntPair hours12) {
        boolean pm = hours12.source == 1;
        int value = hours12.target;
        ParsedFields.validateRange(value, 1, 12, DateTimeTemplateField.HH12.displayName());
        if (pm) {
            if (value == 12) {
                return hours12.target;
            }
            return hours12.target % 12 + 12;
        }
        return value % 12;
    }

    private static void validateRange(int val, int min, int max, String field) {
        if (val < min || val > max) {
            String error = IgniteStringFormatter.format((String)"Invalid value for {} (valid values {} - {}): {}", (Object[])new Object[]{field, min, max, val});
            throw new DateTimeException(error);
        }
    }
}

