/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;

public class IgniteSender
extends SingleRel
implements IgniteRel {
    private static final String REL_TYPE_NAME = "Sender";
    private final long exchangeId;
    private final long targetFragmentId;
    private final IgniteDistribution distribution;

    public IgniteSender(RelOptCluster cluster, RelTraitSet traits, RelNode input, long exchangeId, long targetFragmentId, IgniteDistribution distribution) {
        super(cluster, traits, input);
        assert (this.traitSet.containsIfApplicable((RelTrait)distribution)) : "traits=" + this.traitSet + ", distribution" + distribution;
        assert (distribution != RelDistributions.ANY);
        this.exchangeId = exchangeId;
        this.targetFragmentId = targetFragmentId;
        this.distribution = distribution;
    }

    public IgniteSender(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)input.getDistribution()).replace((RelTrait)IgniteConvention.INSTANCE), input.getInput(), ((Number)input.get("exchangeId")).longValue(), ((Number)input.get("targetFragmentId")).longValue(), (IgniteDistribution)input.getDistribution());
    }

    public long exchangeId() {
        return this.exchangeId;
    }

    public long targetFragmentId() {
        return this.targetFragmentId;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IgniteSender(this.getCluster(), traitSet, (RelNode)IgniteSender.sole(inputs), this.exchangeId, this.targetFragmentId, this.distribution);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteDistribution distribution() {
        return this.distribution;
    }

    public IgniteDistribution sourceDistribution() {
        return (IgniteDistribution)this.input.getTraitSet().getTrait((RelTraitDef)DistributionTraitDef.INSTANCE);
    }

    public RelWriter explainTerms(RelWriter pw) {
        RelWriter writer = super.explainTerms(pw);
        if (pw.getDetailLevel() != SqlExplainLevel.ALL_ATTRIBUTES) {
            return writer;
        }
        return writer.item("exchangeId", (Object)this.exchangeId).item("targetFragmentId", (Object)this.targetFragmentId).item("distribution", (Object)this.distribution());
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        throw new RuntimeException(this.getClass().getName() + "#passThroughTraits() is not implemented.");
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        throw new RuntimeException(this.getClass().getName() + "#deriveTraits() is not implemented.");
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteSender(cluster, this.getTraitSet(), (RelNode)IgniteSender.sole(inputs), this.exchangeId(), this.targetFragmentId(), this.distribution());
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.addDistribution(this.distribution, this.getInput().getRowType()).addTargetFragmentId(this.targetFragmentId);
    }
}

