/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures.file;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.file.ExternalFileList;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
class RowListImpl<RowT>
implements RowList<RowT> {
    private final RowHandler.RowFactory<RowT> rowFactory;
    private final ExternalFileList externalList;

    RowListImpl(DataDirectory workDir, FileIoFactory fileIoFactory, RowHandler.RowFactory<RowT> rowFactory) {
        this.rowFactory = rowFactory;
        this.externalList = new ExternalFileList(workDir, fileIoFactory, rowFactory.columnsCount());
    }

    @Override
    @Nullable
    public RowT get(int index) {
        return this.fromBinaryTuple(this.externalList.get(index));
    }

    @Override
    @Nullable
    public RowT removeLast() {
        @Nullable BinaryTuple row = this.externalList.removeLast();
        return row == null ? null : (RowT)this.fromBinaryTuple(row);
    }

    @Override
    public List<RowT> listView(final UnaryOperator<RowT> transformer) {
        this.externalList.checkClosed();
        return new AbstractList<RowT>(){

            @Override
            @Nullable
            public RowT get(int index) {
                return transformer.apply(RowListImpl.this.get(index));
            }

            @Override
            public int size() {
                return RowListImpl.this.size();
            }
        };
    }

    @Override
    public void add(RowT element) {
        Objects.requireNonNull(element, "element");
        BinaryTuple newRow = this.toBinaryTuple(element);
        this.externalList.add(newRow);
    }

    @Override
    public int size() {
        return this.externalList.size();
    }

    @Override
    public void clear() {
        this.externalList.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.externalList.size() == 0;
    }

    @Override
    public Iterator<RowT> iterator() {
        return CollectionUtils.mapIterable((Iterable)this.externalList, this::fromBinaryTuple, null).iterator();
    }

    public void close() throws Exception {
        this.externalList.close();
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private BinaryTuple toBinaryTuple(@Nullable RowT element) {
        return element == null ? null : this.rowFactory.handler().toBinaryTuple(element);
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private RowT fromBinaryTuple(@Nullable BinaryTuple oldRow) {
        if (oldRow == null) {
            return null;
        }
        return this.rowFactory.create((InternalTuple)oldRow);
    }
}

