/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.memory.structures;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryRowConverter;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchemaTypes;
import org.apache.ignite.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.NativeType;
import org.jetbrains.annotations.Nullable;

public class DistinctSetElementCodec
implements KeyValueCodec<GroupKey, Void> {
    private final RowSchema inputSchema;
    private final ImmutableBitSet groupKeys;
    private final Int2ObjectArrayMap<BinaryTupleSchema.Element> keyElements;
    private final BinaryTupleSchema.Element[] argElements;
    private final NativeType[] argTypes;

    public <RowT> DistinctSetElementCodec(RowSchema inputSchema, ImmutableBitSet groupKeys, List<AccumulatorWrapper<RowT>> accs) {
        this.groupKeys = groupKeys;
        this.inputSchema = inputSchema;
        this.keyElements = new Int2ObjectArrayMap();
        Iterator iterator = groupKeys.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            if (this.keyElements.get(k) != null) continue;
            TypeSpec typeSpec = inputSchema.fields().get(k);
            BinaryTupleSchema.Element element = DistinctSetElementCodec.elementFromTypeSpec(typeSpec);
            this.keyElements.put(k, (Object)element);
        }
        this.argElements = new BinaryTupleSchema.Element[accs.size()];
        this.argTypes = new NativeType[accs.size()];
        int i = 0;
        for (AccumulatorWrapper<RowT> wrapper : accs) {
            BinaryTupleSchema.Element element;
            TypeSpec argTypeSpec = wrapper.getArgumentTypes().get(0);
            this.argElements[i] = element = DistinctSetElementCodec.elementFromTypeSpec(argTypeSpec);
            this.argTypes[i] = RowSchemaTypes.toNativeType(argTypeSpec);
            ++i;
        }
    }

    @Nullable
    private static BinaryTupleSchema.Element elementFromTypeSpec(TypeSpec typeSpec) {
        NativeType nativeType = RowSchemaTypes.toNativeType(typeSpec);
        BinaryTupleSchema.Element keyType = nativeType == null ? null : new BinaryTupleSchema.Element(nativeType, typeSpec.isNullable());
        return keyType;
    }

    @Override
    public BinaryTuple encodeKey(GroupKey key) {
        int accIndex = (Integer)key.field(0);
        Object arg = key.field(1);
        BinaryTupleSchema.Element argumentType = this.argElements[accIndex];
        BinaryTupleBuilder builder = new BinaryTupleBuilder(2 + this.groupKeys.cardinality());
        builder.appendInt(accIndex);
        if (argumentType == null) {
            builder.appendNull();
        } else {
            DistinctSetElementCodec.writeInternalValue(builder, argumentType, arg);
        }
        int i = 2;
        Iterator iterator = this.groupKeys.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            Object internal = key.field(i);
            BinaryTupleSchema.Element keyType = (BinaryTupleSchema.Element)this.keyElements.get(k);
            DistinctSetElementCodec.writeInternalValue(builder, keyType, internal);
            ++i;
        }
        return new BinaryTuple(builder.numElements(), builder.build());
    }

    @Override
    public GroupKey decodeKey(BinaryTuple key) {
        int accIndex = key.intValue(0);
        NativeType argumentType = this.argTypes[accIndex];
        Object argVal = DistinctSetElementCodec.readValueInternal(key, argumentType, 1);
        GroupKey.Builder groupKey = GroupKey.builder(2 + this.groupKeys.cardinality());
        groupKey.add(accIndex);
        groupKey.add(argVal);
        int keyIndex = 2;
        Iterator iterator = this.groupKeys.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            NativeType nativeType = RowSchemaTypes.toNativeType(this.inputSchema.fields().get(k));
            Object internal = DistinctSetElementCodec.readValueInternal(key, nativeType, keyIndex);
            groupKey.add(internal);
            ++keyIndex;
        }
        return groupKey.build();
    }

    private static void writeInternalValue(BinaryTupleBuilder builder, BinaryTupleSchema.Element keyType, Object internal) {
        if (keyType == null || internal == null) {
            builder.appendNull();
        } else {
            Object val = TypeUtils.fromInternal(internal, keyType.typeSpec());
            assert (val != null);
            BinaryRowConverter.appendValue((BinaryTupleBuilder)builder, (BinaryTupleSchema.Element)keyType, (Object)val);
        }
    }

    @Nullable
    private static Object readValueInternal(BinaryTuple key, @Nullable NativeType nativeType, int keyIndex) {
        if (nativeType == null) {
            return null;
        }
        Object val = Commons.readValue((InternalTuple)key, nativeType, keyIndex);
        return TypeUtils.toInternal(val, nativeType.spec());
    }

    @Override
    public ByteBuffer encodeValue(Void val, ByteBuffer buf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Void decodeValue(ByteBuffer buf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int initialValueSizeInBytes() {
        return 0;
    }
}

