/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignmentsImpl;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionDistributionProvider;
import org.apache.ignite.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.systemview.api.SystemViewManager;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;

public class ExecutionDistributionProviderImpl
implements ExecutionDistributionProvider {
    private static final IgniteLogger LOG = Loggers.forClass(ExecutionDistributionProviderImpl.class);
    private final PlacementDriver placementDriver;
    private final SystemViewManager systemViewManager;
    private final NodeProperties nodeProperties;

    public ExecutionDistributionProviderImpl(PlacementDriver placementDriver, SystemViewManager systemViewManager, NodeProperties nodeProperties) {
        this.placementDriver = placementDriver;
        this.systemViewManager = systemViewManager;
        this.nodeProperties = nodeProperties;
    }

    @Override
    public List<String> forSystemView(IgniteSystemView view) {
        return this.systemViewManager.owningNodes(view.name());
    }

    @Override
    public CompletableFuture<List<TokenizedAssignments>> forTable(HybridTimestamp operationTime, IgniteTable table, boolean includeBackups) {
        return this.collectAssignments(table, operationTime, includeBackups);
    }

    private CompletableFuture<List<TokenizedAssignments>> collectAssignments(IgniteTable table, HybridTimestamp operationTime, boolean includeBackups) {
        int partitions = table.partitions();
        if (includeBackups) {
            ArrayList<ReplicationGroupId> replicationGroupIds = new ArrayList<ReplicationGroupId>(partitions);
            for (int partitionIndex = 0; partitionIndex < partitions; ++partitionIndex) {
                replicationGroupIds.add(this.targetReplicationGroupId(table, partitionIndex));
            }
            return this.allReplicas(replicationGroupIds, operationTime);
        }
        ArrayList<CompletableFuture<TokenizedAssignments>> result = new ArrayList<CompletableFuture<TokenizedAssignments>>(partitions);
        for (int partitionIndex = 0; partitionIndex < partitions; ++partitionIndex) {
            ReplicationGroupId partGroupId = this.targetReplicationGroupId(table, partitionIndex);
            CompletableFuture<TokenizedAssignments> partitionAssignment = this.primaryReplica(partGroupId, operationTime);
            result.add(partitionAssignment);
        }
        CompletableFuture<Void> all = CompletableFuture.allOf(result.toArray(new CompletableFuture[0]));
        return all.thenApply(v -> result.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    private ReplicationGroupId targetReplicationGroupId(IgniteTable table, int partitionIndex) {
        if (table.useSecondaryStorage()) {
            return new ZonePartitionId(table.secondaryZoneId().intValue(), partitionIndex);
        }
        if (this.nodeProperties.colocationEnabled()) {
            return new ZonePartitionId(table.zoneId(), partitionIndex);
        }
        return new TablePartitionId(table.id(), partitionIndex);
    }

    private CompletableFuture<TokenizedAssignments> primaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp operationTime) {
        CompletableFuture f = this.placementDriver.awaitPrimaryReplica(replicationGroupId, operationTime, 30L, TimeUnit.SECONDS);
        return f.handle((primaryReplica, e) -> {
            if (e != null) {
                LOG.debug("Failed to retrieve primary replica for partition {}", e, new Object[]{replicationGroupId});
                throw (IgniteInternalException)ExceptionUtils.withCause(IgniteInternalException::new, (int)ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, (String)("Failed to get the primary replica [replicationGroupId=" + replicationGroupId + "]"), (Throwable)e);
            }
            String holder = primaryReplica.getLeaseholder();
            assert (holder != null) : "Unable to map query, nothing holds the lease";
            return new TokenizedAssignmentsImpl(Set.of(Assignment.forPeer((String)holder)), primaryReplica.getStartTime().longValue());
        });
    }

    private CompletableFuture<List<TokenizedAssignments>> allReplicas(List<ReplicationGroupId> replicationGroupIds, HybridTimestamp operationTime) {
        return this.placementDriver.getAssignments(replicationGroupIds, operationTime);
    }
}

