/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp.agg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulators;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchemaTypes;
import org.apache.ignite.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class AccumulatorsFactory<RowT> {
    private static final LoadingCache<Pair<RelDataType, RelDataType>, Function<Object, Object>> CACHE = Caffeine.newBuilder().build(AccumulatorsFactory::cast0);
    private final IgniteTypeFactory typeFactory;
    private final AggregateType type;
    private final RelDataType inputRowType;
    private final List<WrapperPrototype> prototypes;

    private static Function<Object, Object> cast(RelDataType from, RelDataType to) {
        assert (!from.isStruct());
        assert (!to.isStruct());
        return AccumulatorsFactory.cast((Pair<RelDataType, RelDataType>)Pair.of((Object)from, (Object)to));
    }

    private static Function<Object, Object> cast(Pair<RelDataType, RelDataType> types) {
        return (Function)CACHE.get(types);
    }

    private static Function<Object, Object> cast0(Pair<RelDataType, RelDataType> types) {
        IgniteTypeFactory typeFactory = Commons.typeFactory();
        RelDataType from = (RelDataType)types.left;
        RelDataType to = (RelDataType)types.right;
        Class fromType = Primitives.wrap((Class)typeFactory.getJavaClass(from));
        Class toType = Primitives.wrap((Class)typeFactory.getJavaClass(to));
        if (toType.isAssignableFrom(fromType)) {
            return Function.identity();
        }
        if (Void.class == toType) {
            return o -> null;
        }
        return AccumulatorsFactory.compileCast(typeFactory, from, to);
    }

    private static Function<Object, Object> compileCast(IgniteTypeFactory typeFactory, RelDataType from, RelDataType to) {
        RelDataType rowType = TypeUtils.createRowType(typeFactory, List.of(from));
        ParameterExpression in = Expressions.parameter(Object.class, (String)"in");
        RexToLixTranslator.InputGetterImpl getter = new RexToLixTranslator.InputGetterImpl(Map.of(EnumUtils.convert((Expression)in, Object.class, (Type)typeFactory.getJavaClass(from)), PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)rowType, (JavaRowFormat)JavaRowFormat.SCALAR, (boolean)false)));
        RexBuilder builder = Commons.rexBuilder();
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, builder);
        RexNode cast = builder.makeCast(to, (RexNode)builder.makeInputRef(from, 0));
        programBuilder.addProject(cast, null);
        RexProgram program = programBuilder.getProgram();
        BlockBuilder list = new BlockBuilder();
        List<Expression> projects = RexToLixTranslator.translateProjects(program, (JavaTypeFactory)typeFactory, (SqlConformance)SqlConformanceEnum.DEFAULT, list, null, (Expression)DataContext.ROOT, getter, null);
        list.add(projects.get(0));
        MethodDeclaration decl = Expressions.methodDecl((int)1, Object.class, (String)"apply", List.of(in), (BlockStatement)list.toBlock());
        return Commons.compile(CastFunction.class, Expressions.toString(List.of(decl), (String)"\n", (boolean)false));
    }

    public AccumulatorsFactory(AggregateType type, IgniteTypeFactory typeFactory, List<AggregateCall> aggCalls, RelDataType inputRowType) {
        this.type = type;
        this.typeFactory = typeFactory;
        this.inputRowType = inputRowType;
        Accumulators accumulators = new Accumulators(typeFactory);
        this.prototypes = Commons.transform(aggCalls, call -> new WrapperPrototype(accumulators, (AggregateCall)call));
    }

    public List<AccumulatorWrapper<RowT>> get(ExecutionContext<RowT> context) {
        return Commons.transform(this.prototypes, prototype -> prototype.apply(context));
    }

    @FunctionalInterface
    public static interface CastFunction
    extends Function<Object, Object> {
    }

    private final class WrapperPrototype
    implements Function<ExecutionContext<RowT>, AccumulatorWrapper<RowT>> {
        private Supplier<Accumulator> accFactory;
        private final Accumulators accumulators;
        private final AggregateCall call;
        private Function<Object[], Object[]> inAdapter;
        private Function<Object, Object> outAdapter;

        private WrapperPrototype(Accumulators accumulators, AggregateCall call) {
            this.accumulators = accumulators;
            this.call = call;
        }

        @Override
        public AccumulatorWrapper<RowT> apply(ExecutionContext<RowT> context) {
            Accumulator accumulator = this.accumulator(context);
            return new AccumulatorWrapperImpl(context, accumulator, this.call, this.inAdapter, this.outAdapter);
        }

        private Accumulator accumulator(DataContext context) {
            if (this.accFactory != null) {
                return this.accFactory.get();
            }
            this.accFactory = this.accumulators.accumulatorFactory(context, this.call, AccumulatorsFactory.this.inputRowType);
            Accumulator accumulator = this.accFactory.get();
            this.inAdapter = this.createInAdapter(accumulator);
            this.outAdapter = this.createOutAdapter(accumulator);
            return accumulator;
        }

        private Function<Object[], Object[]> createInAdapter(Accumulator accumulator) {
            if (AccumulatorsFactory.this.type == AggregateType.REDUCE || CollectionUtils.nullOrEmpty((Collection)this.call.getArgList())) {
                return Function.identity();
            }
            List<RelDataType> inTypes = SqlTypeUtil.projectTypes((RelDataType)AccumulatorsFactory.this.inputRowType, (List)this.call.getArgList());
            List<RelDataType> outTypes = accumulator.argumentTypes(AccumulatorsFactory.this.typeFactory);
            if (this.call.getArgList().size() > outTypes.size()) {
                throw new AssertionError((Object)("Unexpected number of arguments: expected=" + outTypes.size() + ", actual=" + inTypes.size()));
            }
            if (this.call.ignoreNulls()) {
                inTypes = Commons.transform(inTypes, this::nonNull);
            }
            final List<Function> casts = Commons.transform(Pair.zip((List)inTypes, outTypes), x$0 -> AccumulatorsFactory.cast((Pair<RelDataType, RelDataType>)x$0));
            return new Function<Object[], Object[]>(){

                @Override
                public Object[] apply(Object[] args) {
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = ((Function)casts.get(i)).apply(args[i]);
                    }
                    return args;
                }
            };
        }

        private Function<Object, Object> createOutAdapter(Accumulator accumulator) {
            if (AccumulatorsFactory.this.type == AggregateType.MAP) {
                return Function.identity();
            }
            RelDataType inType = accumulator.returnType(AccumulatorsFactory.this.typeFactory);
            RelDataType outType = this.call.getType();
            return AccumulatorsFactory.cast(inType, outType);
        }

        private RelDataType nonNull(RelDataType type) {
            return AccumulatorsFactory.this.typeFactory.createTypeWithNullability(type, false);
        }
    }

    private static final class AccumulatorWrapperImpl<RowT>
    implements AccumulatorWrapper<RowT> {
        static final IntList SINGLE_ARG_LIST = IntList.of((int)0);
        private static final Object[] NO_ARGUMENTS = new Object[]{null};
        private final Accumulator accumulator;
        private final Function<Object[], Object[]> inAdapter;
        private final Function<Object, Object> outAdapter;
        private final IntList argList;
        private final List<TypeSpec> argTypes;
        private final boolean literalAgg;
        private final int filterArg;
        private final boolean ignoreNulls;
        private final RowHandler<RowT> handler;
        private final boolean distinct;
        private final boolean grouping;

        AccumulatorWrapperImpl(ExecutionContext<RowT> ctx, Accumulator accumulator, AggregateCall call, Function<Object[], Object[]> inAdapter, Function<Object, Object> outAdapter) {
            this.handler = ctx.rowHandler();
            this.accumulator = accumulator;
            this.inAdapter = inAdapter;
            this.outAdapter = outAdapter;
            this.distinct = call.isDistinct();
            this.grouping = call.getAggregation().getKind() == SqlKind.GROUPING;
            this.literalAgg = call.getAggregation().getKind() == SqlKind.LITERAL_AGG;
            this.ignoreNulls = call.ignoreNulls();
            int n = this.filterArg = call.hasFilter() ? call.filterArg : -1;
            if (this.literalAgg) {
                assert (call.getArgList().isEmpty()) : "LiteralAgg should have no operands: " + call;
                RexNode rexNode = (RexNode)call.rexList.get(0);
                NativeType nativeType = TypeUtils.relational2nativeType(rexNode.getType());
                this.argTypes = nativeType == null ? List.of(RowSchemaTypes.NULL) : List.of(RowSchemaTypes.nativeType(nativeType));
                this.argList = SINGLE_ARG_LIST;
            } else {
                assert (call.rexList.isEmpty()) : "Pre-operand list should be empty: " + call;
                List<RelDataType> argumentTypes = accumulator.argumentTypes(ctx.getTypeFactory());
                ArrayList<TypeSpec> nativeTypes = new ArrayList<TypeSpec>(call.getArgList().size());
                for (int i = 0; i < argumentTypes.size(); ++i) {
                    RelDataType fieldType = argumentTypes.get(i);
                    NativeType argType = TypeUtils.relational2nativeType(fieldType);
                    if (argType == null) {
                        nativeTypes.add(RowSchemaTypes.NULL);
                        continue;
                    }
                    nativeTypes.add(RowSchemaTypes.nativeType(argType));
                }
                this.argTypes = nativeTypes;
                this.argList = this.distinct && call.getArgList().isEmpty() ? SINGLE_ARG_LIST : new IntArrayList((Collection)call.getArgList());
            }
        }

        @Override
        public boolean isDistinct() {
            return this.distinct;
        }

        @Override
        public boolean isGrouping() {
            return this.grouping;
        }

        @Override
        public List<TypeSpec> getArgumentTypes() {
            return this.argTypes;
        }

        @Override
        public Accumulator accumulator() {
            return this.accumulator;
        }

        @Override
        public Object @Nullable [] getArguments(RowT row) {
            if (this.filterArg >= 0 && !Boolean.TRUE.equals(this.handler.get(this.filterArg, row))) {
                return null;
            }
            if (this.literalAgg || this.grouping) {
                return NO_ARGUMENTS;
            }
            if (IgniteUtils.assertionsEnabled() && this.distinct && this.argList == SINGLE_ARG_LIST) {
                int cnt = this.handler.columnCount(row);
                assert (cnt <= 1);
            }
            int params = this.argList.size();
            Object[] args = new Object[params];
            for (int i = 0; i < params; ++i) {
                int argPos = this.argList.getInt(i);
                args[i] = this.handler.get(argPos, row);
                if (!this.ignoreNulls || args[i] != null) continue;
                return null;
            }
            return this.inAdapter.apply(args);
        }

        @Override
        public Object convertResult(Object result) {
            return this.outAdapter.apply(result);
        }
    }
}

