/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public class SecuredIgniteSql
implements IgniteSql,
Wrapper {
    private final IgniteSql delegate;
    private final SecurityContext securityContext;

    public SecuredIgniteSql(IgniteSql delegate, SecurityContext securityContext) {
        this.delegate = delegate;
        this.securityContext = securityContext;
    }

    public Statement createStatement(String query) {
        return this.delegate.createStatement(query);
    }

    public Statement.StatementBuilder statementBuilder() {
        return this.delegate.statementBuilder();
    }

    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return (ResultSet)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.execute(transaction, cancellationToken, query, arguments));
    }

    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return (ResultSet)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.execute(transaction, cancellationToken, statement, arguments));
    }

    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return (ResultSet)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.execute(transaction, mapper, cancellationToken, query, arguments));
    }

    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return (ResultSet)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.execute(transaction, mapper, cancellationToken, statement, arguments));
    }

    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeAsync(transaction, cancellationToken, query, arguments));
    }

    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeAsync(transaction, cancellationToken, statement, arguments));
    }

    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeAsync(transaction, mapper, cancellationToken, query, arguments));
    }

    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeAsync(transaction, mapper, cancellationToken, statement, arguments));
    }

    public long[] executeBatch(@Nullable Transaction transaction, String dmlQuery, BatchedArguments batch) {
        return (long[])GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatch(transaction, dmlQuery, batch));
    }

    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String dmlQuery, BatchedArguments batch) {
        return (long[])GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatch(transaction, cancellationToken, dmlQuery, batch));
    }

    public long[] executeBatch(@Nullable Transaction transaction, Statement dmlStatement, BatchedArguments batch) {
        return (long[])GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatch(transaction, dmlStatement, batch));
    }

    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement dmlStatement, BatchedArguments batch) {
        return (long[])GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatch(transaction, cancellationToken, dmlStatement, batch));
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, String query, BatchedArguments batch) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatchAsync(transaction, query, batch));
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatchAsync(transaction, cancellationToken, query, batch));
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, Statement statement, BatchedArguments batch) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatchAsync(transaction, statement, batch));
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, BatchedArguments batch) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeBatchAsync(transaction, cancellationToken, statement, batch));
    }

    public void executeScript(String query, Object ... arguments) {
        GridGainSecurity.with((SecurityContext)this.securityContext, () -> this.delegate.executeScript(query, arguments)).run();
    }

    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        GridGainSecurity.with((SecurityContext)this.securityContext, () -> this.delegate.executeScript(cancellationToken, query, arguments)).run();
    }

    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeScriptAsync(query, arguments));
    }

    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeScriptAsync(cancellationToken, query, arguments));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        if (classToUnwrap.isAssignableFrom(QueryProcessor.class)) {
            return (T)Wrappers.unwrap((Object)this.delegate, classToUnwrap);
        }
        return classToUnwrap.cast(this);
    }
}

